/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.pypi.repair;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.pypi.internal.AssetKind;
import org.sonatype.nexus.repository.repair.RepairMetadataComponent;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.repository.storage.StorageTx;

@Named
@Singleton
public class PyPiRepairIndexComponent
extends RepairMetadataComponent {
    @Inject
    public PyPiRepairIndexComponent(RepositoryManager repositoryManager, AssetEntityAdapter assetEntityAdapter, @Named(value="hosted") Type type, @Named(value="pypi") Format format) {
        super(repositoryManager, assetEntityAdapter, type, format);
    }

    public void updateAsset(Repository repository, StorageTx tx, Asset asset) {
        AssetKind assetKind = AssetKind.valueOf((String)asset.formatAttributes().get("asset_kind", String.class));
        if (AssetKind.ROOT_INDEX.equals((Object)assetKind) || AssetKind.INDEX.equals((Object)assetKind)) {
            tx.deleteAsset(asset);
        }
    }
}

