/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.bower.internal;

import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.bower.internal.GitRemoteBowerResolver;

@Named
@Singleton
public class BitbucketBowerResolver
extends GitRemoteBowerResolver {
    private static final Pattern URL_PATTERN = Pattern.compile("(git|https)(@|://)bitbucket.org[:/]([^/\\s]+?)/([^/\\s]+?)(?:\\.git)?/?$", 2);

    @Override
    public boolean canHandle(String packageUrl) {
        Preconditions.checkNotNull((Object)packageUrl);
        return URL_PATTERN.matcher(packageUrl).matches();
    }

    @Override
    public String getVersionsUrl(String packageUrl, String pkg) {
        Preconditions.checkNotNull((Object)packageUrl);
        Preconditions.checkNotNull((Object)pkg);
        Matcher matcher = URL_PATTERN.matcher(packageUrl);
        if (matcher.find()) {
            String org = matcher.group(3);
            String repo = matcher.group(4);
            return "https://bitbucket.org/" + org + "/" + repo + ".git/info/refs?service=git-upload-pack";
        }
        throw new IllegalStateException();
    }

    @Override
    public String getTarballUrl(String packageUrl, String pkg, String version) {
        Preconditions.checkNotNull((Object)packageUrl);
        Preconditions.checkNotNull((Object)pkg);
        Preconditions.checkNotNull((Object)version);
        Matcher matcher = URL_PATTERN.matcher(packageUrl);
        if (matcher.find()) {
            String org = matcher.group(3);
            String repo = matcher.group(4);
            return "https://bitbucket.org/" + org + "/" + repo + "/get/" + version + ".tar.gz";
        }
        throw new IllegalStateException();
    }
}

