/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.bower.internal;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.bower.internal.InvalidParametersException;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.storage.TempBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.BlobPayload;

public final class BowerFacetUtils {
    static final ObjectMapper mapper = new ObjectMapper();
    static final List<HashAlgorithm> HASH_ALGORITHMS = ImmutableList.of((Object)HashAlgorithm.SHA1);

    private BowerFacetUtils() {
    }

    static Content toContent(Asset asset, Blob blob) {
        Content content = new Content((Payload)new BlobPayload(blob, asset.requireContentType()));
        Content.extractFromAsset((Asset)asset, HASH_ALGORITHMS, (AttributesMap)content.getAttributes());
        return content;
    }

    @Nullable
    static Component findComponent(StorageTx tx, Repository repository, String name, String version) {
        Iterable components = tx.findComponents(Query.builder().where("name").eq((Object)name).and("version").eq((Object)version).build(), Collections.singletonList(repository));
        if (components.iterator().hasNext()) {
            return (Component)components.iterator().next();
        }
        return null;
    }

    @Nullable
    static Asset findAsset(StorageTx tx, Bucket bucket, String assetName) {
        return tx.findAssetWithProperty("name", (Object)assetName, bucket);
    }

    static Content saveAsset(StorageTx tx, Asset asset, Supplier<InputStream> contentSupplier, Payload payload) throws IOException {
        AttributesMap contentAttributes = null;
        String contentType = null;
        if (payload instanceof Content) {
            contentAttributes = ((Content)payload).getAttributes();
            contentType = payload.getContentType();
        }
        return BowerFacetUtils.saveAsset(tx, asset, contentSupplier, contentType, contentAttributes);
    }

    static Content saveAsset(StorageTx tx, Asset asset, Supplier<InputStream> contentSupplier, String contentType, @Nullable AttributesMap contentAttributes) throws IOException {
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)contentAttributes));
        AssetBlob assetBlob = tx.setBlob(asset, asset.name(), contentSupplier, HASH_ALGORITHMS, null, contentType, false);
        tx.saveAsset(asset);
        return BowerFacetUtils.toContent(asset, assetBlob.getBlob());
    }

    static Content saveAsset(StorageTx tx, Asset asset, TempBlob tempBlob, Payload payload) throws IOException {
        AttributesMap contentAttributes = null;
        String contentType = null;
        if (payload instanceof Content) {
            contentAttributes = ((Content)payload).getAttributes();
            contentType = payload.getContentType();
        }
        return BowerFacetUtils.saveAsset(tx, asset, tempBlob, contentType, contentAttributes);
    }

    static Content saveAsset(StorageTx tx, Asset asset, TempBlob tempBlob, String contentType, @Nullable AttributesMap contentAttributes) throws IOException {
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)contentAttributes));
        AssetBlob assetBlob = tx.setBlob(asset, asset.name(), tempBlob, null, contentType, false);
        tx.saveAsset(asset);
        return BowerFacetUtils.toContent(asset, assetBlob.getBlob());
    }

    static Map<String, Object> readPackageMapping(Supplier<InputStream> packageMappingContent) throws IOException {
        TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};
        return (Map)mapper.readValue((InputStream)packageMappingContent.get(), (TypeReference)typeRef);
    }

    static String packageMappingName(String pkg) {
        return String.valueOf(pkg) + "/mapping.json";
    }

    static String packageVersionsName(String pkg) {
        return String.valueOf(pkg) + "/versions.json";
    }

    static String packageTarballName(String pkg, String version) {
        return String.valueOf(pkg) + "/" + version + "/package.tar.gz";
    }

    static TokenMatcher.State matcherState(Context context) {
        return (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
    }

    static String pkg(TokenMatcher.State state) {
        Preconditions.checkNotNull((Object)state);
        String pkg = (String)state.getTokens().get("package");
        Preconditions.checkNotNull((Object)pkg);
        return pkg;
    }

    static String version(TokenMatcher.State state) {
        Preconditions.checkNotNull((Object)state);
        String version = (String)state.getTokens().get("version");
        Preconditions.checkNotNull((Object)version);
        return version;
    }

    static void validateName(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new InvalidParametersException("Invalid Package Name. Package name cannot be empty.");
        }
        if (!name.matches("^.{1,50}$")) {
            throw new InvalidParametersException("Invalid Package Name. Package names must be between 1 and 50 characters");
        }
        if (!name.matches("^[a-z0-9._-]*$")) {
            throw new InvalidParametersException("Invalid Package Name. Package names must only contain lower case a through z, 0 through 9, dots, dashes, and underscores");
        }
        if (name.matches(".*[._-]{2,}.*")) {
            throw new InvalidParametersException("Invalid Package Name. Package names must not have consecutive dashes, dots, or underscores");
        }
        if (!name.matches("^[^._-].*[^._-]$")) {
            throw new InvalidParametersException("Invalid Package Name. Package names must not start or end with dashes, dots, or underscores");
        }
    }

    static void validateURL(String url) {
        if (Strings.isNullOrEmpty((String)url)) {
            throw new InvalidParametersException("Invalid URL. URL cannot be empty.");
        }
    }
}

