/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.bower.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Named;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.bower.internal.AssetKind;
import org.sonatype.nexus.repository.bower.internal.BowerFacetUtils;
import org.sonatype.nexus.repository.bower.internal.BowerHostedFacet;
import org.sonatype.nexus.repository.bower.internal.Mapping;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class BowerHostedFacetImpl
extends FacetSupport
implements BowerHostedFacet {
    @Override
    @TransactionalTouchBlob
    public Content getMapping(String pkg) {
        Preconditions.checkNotNull((Object)pkg);
        return this.getAsset(BowerFacetUtils.packageMappingName(pkg));
    }

    @TransactionalTouchBlob
    protected Content getAsset(String name) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = BowerFacetUtils.findAsset(tx, tx.findBucket(this.getRepository()), name);
        if (asset == null) {
            return null;
        }
        return BowerFacetUtils.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
    }

    @Override
    @TransactionalStoreBlob
    public void putMapping(String pkg, String url) throws IOException {
        BowerFacetUtils.validateName(pkg);
        BowerFacetUtils.validateURL(url);
        Content content = new Content((Payload)new StringPayload(BowerFacetUtils.mapper.writeValueAsString((Object)new Mapping(pkg, url)), "application/json"));
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        String packageMappingName = BowerFacetUtils.packageMappingName(pkg);
        Asset asset = BowerFacetUtils.findAsset(tx, bucket, packageMappingName);
        if (asset == null) {
            asset = tx.createAsset(bucket, this.getRepository().getFormat());
            asset.name(packageMappingName);
            asset.formatAttributes().set("asset_kind", (Object)AssetKind.MAPPING);
        }
        InputStream contentStream = content.openInputStream();
        BowerFacetUtils.saveAsset(tx, asset, (Supplier<InputStream>)((Supplier)() -> contentStream), (Payload)content);
    }
}

