/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.bower.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.bower.internal.AssetKind;
import org.sonatype.nexus.repository.bower.internal.BowerFacetUtils;
import org.sonatype.nexus.repository.bower.internal.BowerProxyFacet;
import org.sonatype.nexus.repository.bower.internal.BowerResolver;
import org.sonatype.nexus.repository.cache.CacheController;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.ConfigurationFacet;
import org.sonatype.nexus.repository.proxy.ProxyFacetSupport;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.storage.TempBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchMetadata;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.ViewFacet;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.StringPayload;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class BowerProxyFacetImpl
extends ProxyFacetSupport
implements BowerProxyFacet {
    private static final String CONFIG_KEY = "bower";
    private final List<BowerResolver> resolvers;
    private Config config;

    @Inject
    public BowerProxyFacetImpl(List<BowerResolver> resolvers) {
        this.resolvers = (List)Preconditions.checkNotNull(resolvers);
    }

    protected void doValidate(Configuration configuration) throws Exception {
        super.doValidate(configuration);
        ((ConfigurationFacet)this.facet(ConfigurationFacet.class)).validateSection(configuration, CONFIG_KEY, Config.class, new Class[0]);
    }

    protected void doConfigure(Configuration configuration) throws Exception {
        super.doConfigure(configuration);
        this.config = (Config)((ConfigurationFacet)this.facet(ConfigurationFacet.class)).readSection(configuration, CONFIG_KEY, Config.class);
        this.log.debug("Config: {}", (Object)this.config);
    }

    @Override
    public boolean isRewritePackageUrls() {
        return this.config.rewritePackageUrls;
    }

    @Nullable
    protected Content getCachedContent(Context context) throws IOException {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        if (assetKind.equals((Object)AssetKind.SEARCH)) {
            return null;
        }
        TokenMatcher.State matcherState = BowerFacetUtils.matcherState(context);
        String pkg = BowerFacetUtils.pkg(matcherState);
        switch (assetKind) {
            case MAPPING: {
                return this.getAsset(BowerFacetUtils.packageMappingName(pkg));
            }
            case VERSIONS: {
                return this.getAsset(BowerFacetUtils.packageVersionsName(pkg));
            }
            case TARBALL: {
                return this.getAsset(BowerFacetUtils.packageTarballName(pkg, BowerFacetUtils.version(matcherState)));
            }
        }
        throw new IllegalStateException();
    }

    protected Content store(Context context, Content content) throws IOException {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        if (assetKind.equals((Object)AssetKind.SEARCH)) {
            return content;
        }
        TokenMatcher.State matcherState = BowerFacetUtils.matcherState(context);
        String pkg = BowerFacetUtils.pkg(matcherState);
        switch (assetKind) {
            case MAPPING: {
                return this.putMapping(pkg, content);
            }
            case VERSIONS: {
                return this.putVersions(pkg, content, context);
            }
            case TARBALL: {
                return this.putTarball(pkg, BowerFacetUtils.version(matcherState), content);
            }
        }
        throw new IllegalStateException();
    }

    @Nonnull
    protected CacheController getCacheController(@Nonnull Context context) {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        return this.cacheControllerHolder.require(assetKind.getCacheType());
    }

    protected void indicateVerified(Context context, Content content, CacheInfo cacheInfo) throws IOException {
        this.setCacheInfo(content, cacheInfo);
    }

    protected String getUrl(@Nonnull Context context) {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        if (assetKind.equals((Object)AssetKind.MAPPING)) {
            return "packages/" + BowerFacetUtils.pkg(BowerFacetUtils.matcherState(context));
        }
        if (assetKind.equals((Object)AssetKind.SEARCH)) {
            String url = context.getRequest().getPath();
            return url.substring(1);
        }
        if (assetKind.equals((Object)AssetKind.VERSIONS) || assetKind.equals((Object)AssetKind.TARBALL)) {
            TokenMatcher.State state = BowerFacetUtils.matcherState(context);
            String pkg = BowerFacetUtils.pkg(state);
            String packageUrl = this.getPackageUrl(pkg, context);
            if (packageUrl != null) {
                for (BowerResolver resolver : this.resolvers) {
                    if (!resolver.canHandle(packageUrl)) continue;
                    if (assetKind.equals((Object)AssetKind.VERSIONS)) {
                        return resolver.getVersionsUrl(packageUrl, pkg);
                    }
                    if (!assetKind.equals((Object)AssetKind.TARBALL)) continue;
                    String version = BowerFacetUtils.version(state);
                    return resolver.getTarballUrl(packageUrl, pkg, version);
                }
            }
            return null;
        }
        throw new IllegalStateException();
    }

    protected Content fetch(String url, Context context, @Nullable Content stale) throws IOException {
        if (url == null) {
            return null;
        }
        return super.fetch(url, context, stale);
    }

    @TransactionalTouchMetadata
    public void setCacheInfo(Content content, CacheInfo cacheInfo) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = Content.findAsset((StorageTx)tx, (Bucket)tx.findBucket(this.getRepository()), (Content)content);
        if (asset == null) {
            this.log.debug("Attempting to set cache info for non-existent bower asset {}", content.getAttributes().require(Asset.class));
            return;
        }
        this.log.debug("Updating cacheInfo of {} to {}", (Object)asset, (Object)cacheInfo);
        CacheInfo.applyToAsset((Asset)asset, (CacheInfo)cacheInfo);
        tx.saveAsset(asset);
    }

    @TransactionalTouchBlob
    protected Content getAsset(String name) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = BowerFacetUtils.findAsset(tx, tx.findBucket(this.getRepository()), name);
        if (asset == null) {
            return null;
        }
        return BowerFacetUtils.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
    }

    private Content putAsset(String name, Content content, Map<String, Object> attributes) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)content, BowerFacetUtils.HASH_ALGORITHMS);){
            return this.doPutAsset(name, tempBlob, (Payload)content, attributes);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected Content doPutAsset(String name, TempBlob tempBlob, Payload payload, Map<String, Object> attributes) throws IOException {
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = BowerFacetUtils.findAsset(tx, bucket = tx.findBucket(this.getRepository()), name);
        if (asset == null) {
            asset = tx.createAsset(bucket, this.getRepository().getFormat());
            asset.name(name);
        }
        if (attributes != null) {
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                asset.formatAttributes().set(entry.getKey(), entry.getValue());
            }
        }
        return BowerFacetUtils.saveAsset(tx, asset, tempBlob, payload);
    }

    private Content putMapping(String pkg, Content content) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)content, BowerFacetUtils.HASH_ALGORITHMS);){
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            Map<String, Object> packageMapping = BowerFacetUtils.readPackageMapping((Supplier<InputStream>)tempBlob);
            attributes.put("asset_kind", (Object)AssetKind.MAPPING);
            attributes.put("package_url", packageMapping.get("url"));
            return this.doPutAsset(BowerFacetUtils.packageMappingName(pkg), tempBlob, (Payload)content, attributes);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Content putVersions(String pkg, Content content, Context context) throws IOException {
        storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        var5_5 = null;
        var6_7 = null;
        try {
            tempBlob = storageFacet.createTempBlob((Payload)content, BowerFacetUtils.HASH_ALGORITHMS);
            var9_10 = this.resolvers.iterator();
            while (true) {
                block9: {
                    resolver = var9_10.next();
                    if (!resolver.canHandle(packageUrl = this.getPackageUrl(pkg, context))) break block9;
                    versions = resolver.getVersions((Supplier<InputStream>)tempBlob);
                    versionsContent = new Content((Payload)new StringPayload(BowerFacetUtils.mapper.writeValueAsString(versions), "application/json"));
                    var14_15 = content.getAttributes().iterator();
                    if (true) ** GOTO lbl27
                }
                break;
            }
            finally {
                if (var9_10.hasNext()) ** continue;
            }
            if (tempBlob == null) throw new IllegalStateException();
            tempBlob.close();
            throw new IllegalStateException();
            do {
                entry = (Map.Entry)var14_15.next();
                versionsContent.getAttributes().set((String)entry.getKey(), entry.getValue());
lbl27:
                // 2 sources

            } while (var14_15.hasNext());
            attributes = new HashMap<String, Object>();
            attributes.put("asset_kind", (Object)AssetKind.VERSIONS);
            return this.putAsset(BowerFacetUtils.packageVersionsName(pkg), versionsContent, attributes);
        }
        catch (Throwable var6_8) {
            if (var5_5 == null) {
                var5_5 = var6_8;
                throw var5_5;
            }
            if (var5_5 == var6_8) throw var5_5;
            var5_5.addSuppressed(var6_8);
            throw var5_5;
        }
    }

    private Content putTarball(String pkg, String version, Content content) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)content, BowerFacetUtils.HASH_ALGORITHMS);){
            return this.doPutTarball(pkg, version, tempBlob, (Payload)content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected Content doPutTarball(String pkg, String version, TempBlob tempBlob, Payload payload) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        String packageTarballName = BowerFacetUtils.packageTarballName(pkg, version);
        Component component = BowerFacetUtils.findComponent(tx, this.getRepository(), pkg, version);
        if (component == null) {
            component = ((Component)tx.createComponent(bucket, this.getRepository().getFormat()).name(pkg)).version(version);
        }
        tx.saveComponent(component);
        Asset asset = BowerFacetUtils.findAsset(tx, bucket, packageTarballName);
        if (asset == null) {
            asset = tx.createAsset(bucket, component);
            asset.name(packageTarballName);
            asset.formatAttributes().set("asset_kind", (Object)AssetKind.TARBALL.name());
        }
        return BowerFacetUtils.saveAsset(tx, asset, tempBlob, payload);
    }

    protected String getPackageUrl(String pkg, Context context) {
        String packageUrl = null;
        if (context.getAttributes().contains("package_url")) {
            packageUrl = (String)context.getAttributes().get("package_url", String.class);
        } else {
            Request mappingRequest = new Request.Builder().action("GET").path("/" + pkg + "/mapping.json").parameter("rewritePackageUrl", new String[]{"false"}).build();
            try {
                Response response = ((ViewFacet)this.getRepository().facet(ViewFacet.class)).dispatch(mappingRequest, context);
                int status = response.getStatus().getCode();
                if (status != 200) {
                    this.log.warn("Failed to fetch mapping json for package {} and repository {}. Received status code {}", new Object[]{pkg, this.getRepository().getName(), status});
                }
                if (response.getPayload() != null) {
                    InputStream mappingInputStream = response.getPayload().openInputStream();
                    packageUrl = (String)BowerFacetUtils.readPackageMapping((Supplier<InputStream>)((Supplier)() -> mappingInputStream)).get("url");
                }
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
            context.getAttributes().set("package_url", (Object)packageUrl);
        }
        return packageUrl;
    }

    private static class Config {
        public Boolean rewritePackageUrls = Boolean.FALSE;

        private Config() {
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "{" + "rewritePackageUrls=" + this.rewritePackageUrls + '}';
        }
    }
}

