/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.bower.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.bower.internal.BowerResolver;

@Named
@Singleton
public abstract class GitRemoteBowerResolver
extends ComponentSupport
implements BowerResolver {
    private static final Pattern REFS_TAGS = Pattern.compile("^([a-f0-9]{44})\\s+refs/tags/(\\S+)");

    @Override
    public Collection<String> getVersions(Supplier<InputStream> contentSupplier) throws IOException {
        Preconditions.checkNotNull(contentSupplier);
        LinkedHashSet<String> versions = new LinkedHashSet<String>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader((InputStream)contentSupplier.get(), StandardCharsets.UTF_8));){
            buffer.lines().forEach(s -> {
                String version;
                Matcher matcher = REFS_TAGS.matcher((CharSequence)s);
                if (matcher.find() && !(version = matcher.group(2)).endsWith("^{}")) {
                    versions.add(version);
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return versions;
    }
}

