/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.bower.internal;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.sonatype.nexus.repository.bower.internal.BowerFacetUtils;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.group.GroupHandler;
import org.sonatype.nexus.repository.http.HttpConditions;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

public abstract class MergingGroupHandler<T>
extends GroupHandler {
    protected Response doGet(@Nonnull Context context, @Nonnull GroupHandler.DispatchedRepositories dispatched) throws Exception {
        List successfulResponses;
        GroupFacet groupFacet = (GroupFacet)context.getRepository().facet(GroupFacet.class);
        HttpConditions.makeUnconditional((Request)context.getRequest());
        try {
            LinkedHashMap responses = this.getAll(context, groupFacet.members(), dispatched);
            successfulResponses = responses.values().stream().filter(response -> response.getStatus().getCode() == 200 && response.getPayload() != null).collect(Collectors.toList());
        }
        finally {
            HttpConditions.makeConditional((Request)context.getRequest());
        }
        if (successfulResponses.isEmpty()) {
            return this.notFoundResponse(context);
        }
        if (successfulResponses.size() == 1) {
            return (Response)successfulResponses.get(0);
        }
        List<List<T>> parts = successfulResponses.stream().map(this::parseResponse).collect(Collectors.toList());
        List<T> merged = this.merge(parts);
        return HttpResponses.ok((Payload)new StringPayload(BowerFacetUtils.mapper.writeValueAsString(merged), "application/json"));
    }

    protected abstract List<T> parseResponse(Response var1);

    private List<T> merge(List<List<T>> parts) {
        ArrayList merged = new ArrayList();
        parts.forEach(part -> part.forEach(entry -> {
            if (!merged.contains(entry)) {
                merged.add(entry);
            }
        }));
        return merged;
    }
}

