/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.bower.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.BaseUrlHolder;
import org.sonatype.nexus.repository.bower.internal.BowerFacetUtils;
import org.sonatype.nexus.repository.bower.internal.BowerProxyFacet;
import org.sonatype.nexus.repository.bower.internal.BowerResolver;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.TempBlob;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Named
@Singleton
class RewritePackageUrlHandler
implements Handler {
    static final String REWRITE_PACKAGE_URL = "rewritePackageUrl";
    static final String OVERRIDE_REPOSITORY_NAME = String.valueOf(RewritePackageUrlHandler.class.getName()) + ".overrideRepositoryName";
    private final List<BowerResolver> resolvers;

    @Inject
    public RewritePackageUrlHandler(List<BowerResolver> resolvers) {
        this.resolvers = (List)Preconditions.checkNotNull(resolvers);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        Response response = context.proceed();
        if (response.getStatus().getCode() != 200) return response;
        if (response.getPayload() == null) return response;
        boolean rewritePackageUrl = context.getRequest().getParameters().contains(REWRITE_PACKAGE_URL) ? Boolean.parseBoolean(context.getRequest().getParameters().get(REWRITE_PACKAGE_URL)) : ((BowerProxyFacet)context.getRepository().facet(BowerProxyFacet.class)).isRewritePackageUrls();
        if (!rewritePackageUrl) return response;
        StorageFacet storageFacet = (StorageFacet)context.getRepository().facet(StorageFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            TempBlob tempBlob;
            block9: {
                tempBlob = storageFacet.createTempBlob(response.getPayload(), Collections.emptyList());
                Map<String, Object> packageMapping = BowerFacetUtils.readPackageMapping((Supplier<InputStream>)tempBlob);
                String url = (String)packageMapping.get("url");
                Iterator<BowerResolver> iterator = this.resolvers.iterator();
                finally {
                    if (!iterator.hasNext()) break block9;
                }
                BowerResolver resolver = iterator.next();
                if (resolver.canHandle(url)) {
                    String repositoryName = (String)context.getRequest().getAttributes().get(OVERRIDE_REPOSITORY_NAME, String.class);
                    if (repositoryName == null) {
                        repositoryName = context.getRepository().getName();
                    }
                    String pkg = BowerFacetUtils.pkg(BowerFacetUtils.matcherState(context));
                    packageMapping.put("url", "nexus+" + BaseUrlHolder.get() + "/repository/" + repositoryName + "/" + pkg);
                    return HttpResponses.ok((Payload)new StringPayload(BowerFacetUtils.mapper.writeValueAsString(packageMapping), "application/json"));
                }
            }
            if (tempBlob == null) return response;
            tempBlob.close();
            return response;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }
}

