/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.goodies.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;

public class Properties2 {
    private Properties2() {
    }

    public static Properties load(File file) throws IOException {
        Preconditions.checkNotNull((Object)file);
        if (file.exists()) {
            return Properties2.load(file.toURI().toURL());
        }
        throw new FileNotFoundException("Could not find file: " + file.getAbsolutePath());
    }

    public static Properties load(URL url) throws IOException {
        Preconditions.checkNotNull((Object)url);
        Properties result = new Properties();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
            result.load(reader);
        }
        return result;
    }

    @Deprecated
    public static String getSystemProperty(Class<?> type, String name, @Nullable Object defaultValue) {
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull((Object)name);
        if (defaultValue == null) {
            return System.getProperty(type.getName() + "." + name);
        }
        return System.getProperty(type.getName() + "." + name, String.valueOf(defaultValue));
    }

    @Deprecated
    public static String getSystemProperty(Class<?> type, String name) {
        return Properties2.getSystemProperty(type, name, null);
    }

    public static Collection<String> sortKeys(Properties source) {
        Preconditions.checkNotNull((Object)source);
        ArrayList keys = Lists.newArrayList(source.keySet());
        Collections.sort(keys);
        return keys;
    }

    public static Collection<String> sortKeys(Map<String, String> source) {
        Preconditions.checkNotNull(source);
        ArrayList keys = Lists.newArrayList(source.keySet());
        Collections.sort(keys);
        return keys;
    }
}

