/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.goodies.common;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class PropertiesLoader {
    private final Properties props = new Properties();
    private final Class owner;
    private final String resourceName;

    public PropertiesLoader(Class owner, String resourceName) {
        this.owner = (Class)Preconditions.checkNotNull((Object)owner);
        this.resourceName = (String)Preconditions.checkNotNull((Object)resourceName);
    }

    public PropertiesLoader(Object owner, String resourceName) {
        this(owner.getClass(), resourceName);
    }

    public Properties getProperties() {
        return this.props;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public PropertiesLoader load() {
        try (InputStream input = this.getResource().openStream();){
            this.props.load(input);
        }
        catch (IOException e) {
            throw new Error("Failed to load properties", e);
        }
        return this;
    }

    public URL getResource() {
        String name = this.getResourceName();
        URL url = this.owner.getResource(name);
        if (url == null) {
            throw new Error("Unable to load resource: " + name);
        }
        return url;
    }

    public String getValue(String name, String defaultValue) {
        String value = this.getProperties().getProperty(name);
        if (value == null || value.trim().length() == 0) {
            return defaultValue;
        }
        return value;
    }

    public String getValue(String name) {
        return this.getValue(name, null);
    }

    public String toString() {
        return this.props.toString();
    }
}

