/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.goodies.common;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;

public final class Time {
    private final long value;
    private final TimeUnit unit;
    private static final ParseConfig[] PARSE_CONFIGS = new ParseConfig[]{new ParseConfig(TimeUnit.SECONDS, new String[]{"seconds", "second", "sec", "s"}), new ParseConfig(TimeUnit.MINUTES, new String[]{"minutes", "minute", "min", "m"}), new ParseConfig(TimeUnit.HOURS, new String[]{"hours", "hour", "hr", "h"}), new ParseConfig(TimeUnit.DAYS, new String[]{"days", "day", "d"}), new ParseConfig(TimeUnit.MILLISECONDS, new String[]{"milliseconds", "millisecond", "millis", "ms"}), new ParseConfig(TimeUnit.NANOSECONDS, new String[]{"nanoseconds", "nanosecond", "nanos", "ns"}), new ParseConfig(TimeUnit.MICROSECONDS, new String[]{"microseconds", "microsecond", "micros", "us"})};

    public Time(long value, TimeUnit unit) {
        this.value = value;
        this.unit = (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)unit)));
    }

    @Deprecated
    public long getValue() {
        return this.value;
    }

    public long value() {
        return this.value;
    }

    @Deprecated
    public TimeUnit getUnit() {
        return this.unit;
    }

    public TimeUnit unit() {
        return this.unit;
    }

    public long toNanos() {
        return this.unit.toNanos(this.value);
    }

    public int toNanosI() {
        return (int)this.toNanos();
    }

    public Time asNanos() {
        return Time.nanos(this.toNanos());
    }

    public long toMicros() {
        return this.unit.toMicros(this.value);
    }

    public int toMicrosI() {
        return (int)this.toMicros();
    }

    public Time asMicros() {
        return Time.micros(this.toMicros());
    }

    public long toMillis() {
        return this.unit.toMillis(this.value);
    }

    public int toMillisI() {
        return (int)this.toMillis();
    }

    public Time asMillis() {
        return Time.millis(this.toMillis());
    }

    public long toSeconds() {
        return this.unit.toSeconds(this.value);
    }

    public int toSecondsI() {
        return (int)this.toSeconds();
    }

    public Time asSeconds() {
        return Time.seconds(this.toSeconds());
    }

    public long toMinutes() {
        return this.unit.toMinutes(this.value);
    }

    public int toMinutesI() {
        return (int)this.toMinutes();
    }

    public Time asMinutes() {
        return Time.minutes(this.toMinutes());
    }

    public long toHours() {
        return this.unit.toHours(this.value);
    }

    public int toHoursI() {
        return (int)this.toHours();
    }

    public Time asHours() {
        return Time.hours(this.toHours());
    }

    public long toDays() {
        return this.unit.toDays(this.value);
    }

    public int toDaysI() {
        return (int)this.toDays();
    }

    public Time asDays() {
        return Time.days(this.toDays());
    }

    public void sleep() throws InterruptedException {
        this.unit.sleep(this.value);
    }

    public void wait(Object obj) throws InterruptedException {
        Preconditions.checkNotNull((Object)obj);
        this.unit.timedWait(obj, this.value);
    }

    public void join(Thread thread) throws InterruptedException {
        Preconditions.checkNotNull((Object)thread);
        this.unit.timedJoin(thread, this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Time that = (Time)obj;
        return this.value == that.value && this.unit == that.unit;
    }

    public int hashCode() {
        int result = (int)(this.value ^ this.value >>> 32);
        result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
        return result;
    }

    private String unitName() {
        String name = this.unit.name().toLowerCase();
        if (this.value == 1L) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    public String toString() {
        return String.format("%d %s", this.value, this.unitName());
    }

    public static Time time(long value, TimeUnit unit) {
        return new Time(value, unit);
    }

    public static Time nanos(long value) {
        return new Time(value, TimeUnit.NANOSECONDS);
    }

    public static Time micros(long value) {
        return new Time(value, TimeUnit.MICROSECONDS);
    }

    public static Time millis(long value) {
        return new Time(value, TimeUnit.MILLISECONDS);
    }

    public static Time seconds(long value) {
        return new Time(value, TimeUnit.SECONDS);
    }

    public static Time minutes(long value) {
        return new Time(value, TimeUnit.MINUTES);
    }

    public static Time hours(long value) {
        return new Time(value, TimeUnit.HOURS);
    }

    public static Time days(long value) {
        return new Time(value, TimeUnit.DAYS);
    }

    public static Time parse(String value) {
        if (value != null) {
            return Time.doParse(value.trim().toLowerCase());
        }
        return null;
    }

    private static Time doParse(String value) {
        for (ParseConfig config : PARSE_CONFIGS) {
            Time t = Time.extract(value, config.unit, config.suffixes);
            if (t == null) continue;
            return t;
        }
        throw new RuntimeException("Unable to parse: " + value);
    }

    private static Time extract(String value, TimeUnit unit, String ... suffixes) {
        String number = null;
        String units = null;
        for (int p = 0; p < value.length(); ++p) {
            if (Character.isDigit(value.charAt(p))) continue;
            number = value.substring(0, p);
            units = value.substring(p, value.length()).trim();
            break;
        }
        if (units != null) {
            for (String suffix : suffixes) {
                if (!suffix.equals(units)) continue;
                long n = Long.parseLong(number.trim());
                return new Time(n, unit);
            }
        }
        return null;
    }

    private static class ParseConfig {
        final TimeUnit unit;
        final String[] suffixes;

        private ParseConfig(TimeUnit unit, String ... suffixes) {
            this.unit = unit;
            this.suffixes = suffixes;
        }
    }
}

