/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.licensing.ext.internal;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.licensing.ext.LicenseChangedEvent;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.licensing.product.ProductLicenseKey;
import org.sonatype.nexus.audit.AuditData;
import org.sonatype.nexus.audit.AuditorSupport;
import org.sonatype.nexus.common.event.EventAware;

@Named
@Singleton
public class LicenseAuditor
extends AuditorSupport
implements EventAware {
    public static final String DOMAIN = "license";

    public LicenseAuditor() {
        this.registerType(LicenseChangedEvent.class, "changed");
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(LicenseChangedEvent event) {
        if (this.isRecording()) {
            AuditData data = new AuditData();
            data.setDomain(DOMAIN);
            data.setType(this.type(event.getClass()));
            data.setContext("system");
            Map attributes = data.getAttributes();
            attributes.put("installed", LicenseAuditor.string((Object)event.isLicenseInstalled()));
            attributes.put("valid", LicenseAuditor.string((Object)event.isLicenseValid()));
            ProductLicenseKey licenseKey = event.getLicenseKey();
            if (licenseKey != null) {
                attributes.put("free", LicenseAuditor.string((Object)licenseKey.isFreeLicense()));
                attributes.put("evaluation", LicenseAuditor.string((Object)licenseKey.isEvaluation()));
                attributes.put("licensedUsers", LicenseAuditor.string((Object)licenseKey.getLicensedUsers()));
                attributes.put("effectiveDate", LicenseAuditor.string((Object)licenseKey.getEffectiveDate()));
                attributes.put("expirationDate", LicenseAuditor.string((Object)licenseKey.getExpirationDate()));
                attributes.put("features", LicenseAuditor.string((Iterable)licenseKey.getRawFeatures()));
            }
            this.record(data);
        }
    }
}

