/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.staging.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.staging.internal.BadRequestStagingException;
import com.sonatype.nexus.staging.internal.NotFoundStagingException;
import com.sonatype.nexus.staging.internal.PermissionStagingException;
import com.sonatype.nexus.staging.internal.StagingResponse;
import com.sonatype.nexus.staging.internal.StagingService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.rest.NoQueryParamException;
import org.sonatype.nexus.rest.Resource;

@Named
@Singleton
@Path(value="/v1/staging")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="staging")
public class StagingResource
extends ComponentSupport
implements Resource {
    public static final String RESOURCE_URI = "/v1/staging";
    public static final String MOVE_URI = "/move/{destination}";
    public static final String DELETE_URI = "/delete";
    public static final String DESTINATION = "destination";
    private final StagingService stagingService;

    @Inject
    public StagingResource(StagingService stagingService) {
        this.stagingService = (StagingService)((Object)Preconditions.checkNotNull((Object)((Object)stagingService)));
    }

    @POST
    @Path(value="/move/{destination}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Move components")
    @ApiResponses(value={@ApiResponse(code=200, message="Move Successful"), @ApiResponse(code=400, message="Invalid client request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Authentication required"), @ApiResponse(code=404, message="No components found")})
    @RequiresAuthentication
    public Response move(@PathParam(value="destination") String destination, @Context UriInfo uriInfo) {
        if (uriInfo.getQueryParameters().isEmpty()) {
            throw new NoQueryParamException();
        }
        try {
            return this.ok("Move Successful", this.stagingService.move(destination, uriInfo));
        }
        catch (BadRequestStagingException br) {
            return this.badRequest(br);
        }
        catch (NotFoundStagingException nf) {
            return this.notFound(nf);
        }
        catch (PermissionStagingException p) {
            return this.forbidden(p);
        }
    }

    @POST
    @Path(value="/delete")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete components")
    @ApiResponses(value={@ApiResponse(code=200, message="Delete Successful"), @ApiResponse(code=400, message="Invalid client request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="No components found")})
    @RequiresAuthentication
    public Response delete(@Context UriInfo uriInfo) {
        if (uriInfo.getQueryParameters().isEmpty()) {
            throw new NoQueryParamException();
        }
        try {
            return this.ok("Delete Successful", this.stagingService.delete(uriInfo));
        }
        catch (BadRequestStagingException br) {
            return this.badRequest(br);
        }
        catch (NotFoundStagingException nf) {
            return this.notFound(nf);
        }
        catch (PermissionStagingException p) {
            return this.forbidden(p);
        }
    }

    private Response ok(String message, Map<?, ?> data) {
        StagingResponse ok = new StagingResponse();
        ok.setStatus(Response.Status.OK.getStatusCode());
        ok.setMessage(message);
        ok.setData(data);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)ok).type("application/json").build();
    }

    private Response badRequest(BadRequestStagingException e) {
        StagingResponse badRequest = new StagingResponse();
        badRequest.setStatus(Response.Status.BAD_REQUEST.getStatusCode());
        badRequest.setMessage(e.getMessage());
        badRequest.setData(e.getData());
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)badRequest).type("application/json").build();
    }

    private Response notFound(NotFoundStagingException e) {
        StagingResponse notFound = new StagingResponse();
        notFound.setStatus(Response.Status.NOT_FOUND.getStatusCode());
        notFound.setMessage(e.getMessage());
        notFound.setData(e.getData());
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)notFound).type("application/json").build();
    }

    private Response forbidden(PermissionStagingException e) {
        StagingResponse unauthorized = new StagingResponse();
        unauthorized.setStatus(Response.Status.FORBIDDEN.getStatusCode());
        unauthorized.setMessage(e.getMessage());
        unauthorized.setData(e.getData());
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)unauthorized).type("application/json").build();
    }
}

