/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.staging.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.sonatype.nexus.staging.internal.BadRequestStagingException;
import com.sonatype.nexus.staging.internal.NotFoundStagingException;
import com.sonatype.nexus.staging.internal.PermissionStagingException;
import com.sonatype.nexus.staging.internal.StagingComponentManager;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.core.UriInfo;
import org.apache.shiro.authz.Permission;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.sonatype.nexus.common.entity.DetachedEntityId;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.entity.EntityMetadata;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.rest.SearchUtils;
import org.sonatype.nexus.repository.rest.api.ComponentResponseUtils;
import org.sonatype.nexus.repository.search.SearchService;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.RepositoryViewPermission;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.security.VariableResolverAdapterManager;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.BucketStore;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentDirector;
import org.sonatype.nexus.repository.storage.ComponentMaintenance;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.security.SecurityHelper;

@Named
@Singleton
public class StagingService
extends StateGuardLifecycleSupport {
    private static final Set<String> SUPPORTED_REPO_TYPES = ImmutableSet.of((Object)"hosted");
    private static final String REPOSITORY = "repository";
    private static final String TYPE = "type";
    private static final String FORMAT = "format";
    private static final String SOURCE = "source";
    private static final String GROUP = "group";
    private static final String NAME = "name";
    private static final String VERSION = "version";
    private static final String N_A = "n/a";
    private static final String DESTINATION = "destination";
    private static final String COMPONENT = "component";
    private static final String COMPONENTS_MOVED = "components moved";
    private static final String COMPONENTS_DELETED = "components deleted";
    private final RepositoryManager repositoryManager;
    private final SearchService searchService;
    private final BucketStore bucketStore;
    private final StagingComponentManager componentManager;
    private final Map<String, ComponentDirector> componentDirectors;
    private final SearchUtils searchUtils;
    private final SecurityHelper securityHelper;
    private final ContentPermissionChecker permissionsChecker;
    private final VariableResolverAdapterManager variableResolverAdapterManager;

    @Inject
    public StagingService(RepositoryManager repositoryManager, SearchService searchService, BucketStore bucketStore, StagingComponentManager componentManager, Map<String, ComponentDirector> componentDirectors, SearchUtils searchUtils, SecurityHelper securityHelper, ContentPermissionChecker permissionsChecker, VariableResolverAdapterManager variableResolverAdapterManager) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.searchService = (SearchService)Preconditions.checkNotNull((Object)searchService);
        this.bucketStore = (BucketStore)Preconditions.checkNotNull((Object)bucketStore);
        this.componentManager = (StagingComponentManager)((Object)Preconditions.checkNotNull((Object)((Object)componentManager)));
        this.componentDirectors = (Map)Preconditions.checkNotNull(componentDirectors);
        this.searchUtils = (SearchUtils)Preconditions.checkNotNull((Object)searchUtils);
        this.securityHelper = (SecurityHelper)Preconditions.checkNotNull((Object)securityHelper);
        this.permissionsChecker = (ContentPermissionChecker)Preconditions.checkNotNull((Object)permissionsChecker);
        this.variableResolverAdapterManager = (VariableResolverAdapterManager)Preconditions.checkNotNull((Object)variableResolverAdapterManager);
    }

    @Guarded(by={"STARTED"})
    public Map<String, Object> move(String destination, UriInfo uriInfo) {
        Repository destRepo = this.validDestinationRepository(destination);
        this.checkForDestinationRepositoryTypeSupport(destRepo);
        ComponentDirector componentDirector = this.validComponentDirector(destRepo);
        this.checkAllowMoveTo(componentDirector, destRepo);
        QueryBuilder query = this.searchUtils.buildQuery(uriInfo);
        Iterable searchHits = this.searchService.browse(query);
        this.checkComponentsFound(destination, uriInfo, searchHits);
        Map<String, String> hits = StreamSupport.stream(searchHits.spliterator(), false).collect(Collectors.toMap(SearchHit::getId, hit -> (String)hit.getSource().get("repository_name")));
        HashSet sources = Sets.newHashSet(hits.values());
        this.checkMoveFromPermissions(sources, hits);
        this.checkMoveToPermissions(destRepo, hits);
        this.checkForSourceRepositoryTypeSupport(sources);
        this.checkForCrossFormatMoves(destination, sources);
        this.checkAllowMoveFrom(componentDirector, sources);
        this.checkAllowMoveTo(hits, destRepo, componentDirector);
        ArrayList<Map> moved = new ArrayList<Map>();
        for (Map.Entry<String, String> hit2 : hits.entrySet()) {
            this.log.debug("processing search hit for move: {}", hit2);
            Repository repository = this.getRepository(hit2.getValue());
            Component component = this.componentManager.move(componentDirector, (EntityId)new DetachedEntityId(hit2.getKey()), repository, destRepo);
            moved.add(ComponentResponseUtils.mapFor((Component)component));
        }
        componentDirector.afterMove(moved, destRepo);
        return StagingService.map(DESTINATION, destination, COMPONENTS_MOVED, moved);
    }

    @Guarded(by={"STARTED"})
    public Map<String, Object> delete(UriInfo uriInfo) {
        QueryBuilder query = this.searchUtils.buildQuery(uriInfo);
        Iterable searchHits = this.searchService.browseUnrestricted(query);
        if (Iterables.isEmpty((Iterable)searchHits)) {
            throw new NotFoundStagingException("No components found", (Map<String, ? extends Object>)StagingService.map("query parameters", uriInfo.getQueryParameters()));
        }
        Map<String, Map<String, String>> hits = StreamSupport.stream(searchHits.spliterator(), false).collect(Collectors.toMap(SearchHit::getId, this::hitForDelete));
        this.checkAllowDelete(hits);
        ArrayList<Map<String, String>> deleted = new ArrayList<Map<String, String>>();
        for (Map.Entry<String, Map<String, String>> hit : hits.entrySet()) {
            this.log.debug("processing search hit for deletion: {}", hit);
            Repository repository = this.getRepository(hit.getValue().get(REPOSITORY));
            ((ComponentMaintenance)repository.facet(ComponentMaintenance.class)).deleteComponent((EntityId)new DetachedEntityId(hit.getKey()));
            deleted.add(hit.getValue());
        }
        return StagingService.map(COMPONENTS_DELETED, deleted);
    }

    private boolean isPermitted(Repository repository, String action) {
        return this.securityHelper.allPermitted(new Permission[]{new RepositoryViewPermission(repository, new String[]{action})});
    }

    private boolean allPermitted(Set<String> repositoryNames, String action) {
        return repositoryNames.stream().map(this::getRepository).allMatch(r -> this.isPermitted((Repository)r, action));
    }

    private boolean isPermitted(Repository repository, List<Asset> assets, String action) {
        String format = repository.getFormat().getValue();
        VariableResolverAdapter adapter = this.variableResolverAdapterManager.get(format);
        return assets.stream().allMatch(a -> this.permissionsChecker.isPermitted(repository.getName(), format, action, adapter.fromAsset(a)));
    }

    private void checkAllowDelete(Map<String, Map<String, String>> hits) {
        hits.entrySet().stream().filter(hit -> {
            DetachedEntityId componentId;
            Map.Entry<Component, List<Asset>> entry;
            Repository source = this.getRepository((String)((Map)hit.getValue()).get(REPOSITORY));
            return !this.isPermitted(source, (entry = this.getComponentAssets(source, (EntityId)(componentId = new DetachedEntityId((String)hit.getKey())))).getValue(), "delete");
        }).map(hit -> new PermissionStagingException("Delete not permitted", (Map)hit.getValue())).findFirst().ifPresent(e -> {
            throw e;
        });
    }

    private Repository validDestinationRepository(String destination) {
        Optional<EntityId> optEntityId = this.entityIdFor(destination);
        Optional<Repository> destRepo = this.repositoryFor(destination);
        if (!optEntityId.isPresent() || !destRepo.isPresent()) {
            throw new BadRequestStagingException("Destination repository not found", (Map<String, ? extends Object>)StagingService.map(REPOSITORY, destination));
        }
        return destRepo.get();
    }

    private void checkForDestinationRepositoryTypeSupport(Repository destination) {
        if (this.repoTypeNotSupported(destination)) {
            throw new BadRequestStagingException("Destination repository type not supported", (Map<String, ? extends Object>)StagingService.map(REPOSITORY, destination.getName(), TYPE, this.repoTypeFor(destination).orElse(N_A)));
        }
    }

    private ComponentDirector validComponentDirector(Repository destination) {
        return Optional.of(destination).map(Repository::getFormat).map(Format::getValue).map(this.componentDirectors::get).orElseThrow(() -> new BadRequestStagingException("Destination repository format not supported", (Map<String, ? extends Object>)StagingService.map(REPOSITORY, destination.getName(), FORMAT, this.formatFor(destination).orElse(N_A))));
    }

    private void checkAllowMoveTo(ComponentDirector componentDirector, Repository destination) {
        if (!componentDirector.allowMoveTo(destination)) {
            throw new BadRequestStagingException("Move not supported for destination repository", (Map<String, ? extends Object>)StagingService.map(REPOSITORY, destination.getName(), FORMAT, this.formatFor(destination).orElse(N_A)));
        }
    }

    private void checkComponentsFound(String destination, UriInfo uriInfo, Iterable<SearchHit> searchHits) {
        if (Iterables.isEmpty(searchHits)) {
            throw new NotFoundStagingException("No components found", (Map<String, ? extends Object>)StagingService.map(DESTINATION, destination, "query parameters", uriInfo.getQueryParameters()));
        }
    }

    private void checkMoveToPermissions(Repository destination, Map<String, String> hits) {
        if (this.isPermitted(destination, "add")) {
            return;
        }
        for (Map.Entry<String, String> hit : hits.entrySet()) {
            DetachedEntityId componentId;
            Repository source = this.getRepository(hit.getValue());
            Map.Entry<Component, List<Asset>> entry = this.getComponentAssets(source, (EntityId)(componentId = new DetachedEntityId(hit.getKey())));
            if (this.isPermitted(destination, entry.getValue(), "add")) continue;
            throw new PermissionStagingException("Move to repository not permitted", (Map<String, ? extends Object>)StagingService.map(REPOSITORY, destination.getName(), COMPONENT, ComponentResponseUtils.mapFor((Component)entry.getKey())));
        }
    }

    private void checkMoveFromPermissions(Set<String> sources, Map<String, String> hits) {
        if (this.allPermitted(sources, "delete")) {
            return;
        }
        for (Map.Entry<String, String> hit : hits.entrySet()) {
            DetachedEntityId componentId;
            Map.Entry<Component, List<Asset>> entry;
            Repository source = this.getRepository(hit.getValue());
            if (this.isPermitted(source, (entry = this.getComponentAssets(source, (EntityId)(componentId = new DetachedEntityId(hit.getKey())))).getValue(), "delete")) continue;
            throw new PermissionStagingException("Move from repository not permitted", (Map<String, ? extends Object>)StagingService.map(REPOSITORY, source.getName(), COMPONENT, ComponentResponseUtils.mapFor((Component)entry.getKey())));
        }
    }

    private Map.Entry<Component, List<Asset>> getComponentAssets(Repository source, EntityId componentId) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (StorageTx tx = (StorageTx)((StorageFacet)source.facet(StorageFacet.class)).txSupplier().get();){
            tx.begin();
            Component component = tx.findComponent(componentId);
            return new AbstractMap.SimpleEntry<Component, List<Asset>>(component, Lists.newArrayList((Iterable)tx.browseAssets(component)));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void checkForSourceRepositoryTypeSupport(Set<String> sources) {
        sources.stream().filter(this::repoTypeNotSupported).map(s -> new BadRequestStagingException("Source repository type not supported", (Map<String, ? extends Object>)StagingService.map(REPOSITORY, s, TYPE, this.repoTypeFor((String)s).orElse(N_A)))).findFirst().ifPresent(e -> {
            throw e;
        });
    }

    private void checkForCrossFormatMoves(String destination, Set<String> sources) {
        sources.stream().filter(s -> !this.sameFormat((String)s, destination)).map(s -> new BadRequestStagingException("Source and destination repository formats do not match", (Map<String, ? extends Object>)StagingService.map(SOURCE, StagingService.map(REPOSITORY, s, FORMAT, this.formatFor((String)s).orElse(N_A)), DESTINATION, StagingService.map(REPOSITORY, destination, FORMAT, this.formatFor(destination).orElse(N_A))))).findFirst().ifPresent(e -> {
            throw e;
        });
    }

    private void checkAllowMoveFrom(ComponentDirector componentDirector, Set<String> sources) {
        sources.stream().map(this::getRepository).filter(r -> !componentDirector.allowMoveFrom(r)).map(r -> new BadRequestStagingException("Move not supported for source repository", (Map<String, ? extends Object>)StagingService.map(REPOSITORY, r.getName(), FORMAT, this.formatFor((Repository)r).orElse(N_A)))).findFirst().ifPresent(e -> {
            throw e;
        });
    }

    private void checkAllowMoveTo(Map<String, String> hits, Repository destRepo, ComponentDirector componentDirector) {
        for (Map.Entry<String, String> hit : hits.entrySet()) {
            Repository repository = this.getRepository(hit.getValue());
            try {
                this.componentManager.verifyMove(componentDirector, (EntityId)new DetachedEntityId(hit.getKey()), repository, destRepo);
            }
            catch (StagingComponentManager.MoveNotAllowedException e) {
                throw new BadRequestStagingException(e.getMessage(), (Map<String, ? extends Object>)StagingService.map(SOURCE, StagingService.map(REPOSITORY, repository.getName(), FORMAT, repository.getFormat().getValue()), DESTINATION, StagingService.map(REPOSITORY, destRepo.getName(), FORMAT, destRepo.getFormat().getValue())));
            }
        }
    }

    private Map<String, String> hitForDelete(SearchHit hit) {
        Map source = hit.getSource();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ComponentResponseUtils.maybePut((ImmutableMap.Builder)builder, (Object)source, s -> (String)s.get("repository_name"), (String)REPOSITORY);
        ComponentResponseUtils.maybePut((ImmutableMap.Builder)builder, (Object)source, s -> (String)s.get(GROUP), (String)GROUP);
        ComponentResponseUtils.maybePut((ImmutableMap.Builder)builder, (Object)source, s -> (String)s.get(NAME), (String)NAME);
        ComponentResponseUtils.maybePut((ImmutableMap.Builder)builder, (Object)source, s -> (String)s.get(VERSION), (String)VERSION);
        return builder.build();
    }

    private static <K, V> ImmutableMap<K, V> map(K k, V v) {
        return ImmutableMap.of(k, v);
    }

    private static <K, V> ImmutableMap<K, V> map(K k1, V v1, K k2, V v2) {
        return ImmutableMap.of(k1, v1, k2, v2);
    }

    private Repository getRepository(String repository) {
        return this.repositoryManager.get(repository);
    }

    private boolean repoTypeNotSupported(String repository) {
        return this.repoTypeNotSupported(this.repositoryFor(repository));
    }

    private boolean repoTypeNotSupported(Repository repository) {
        return this.repoTypeNotSupported(Optional.of(repository));
    }

    private boolean repoTypeNotSupported(Optional<Repository> repository) {
        return this.repoTypeFor(repository).map(SUPPORTED_REPO_TYPES::contains).map(b -> b == false).orElse(Boolean.TRUE);
    }

    private boolean sameFormat(String srcRepoName, String dstRepoName) {
        Optional<String> srcFormat = this.formatFor(srcRepoName);
        Optional<String> dstFormat = this.formatFor(dstRepoName);
        return srcFormat.isPresent() && dstFormat.isPresent() && srcFormat.get().equals(dstFormat.get());
    }

    private Optional<EntityId> entityIdFor(String repositoryName) {
        return Optional.of(this.bucketStore).map(b -> b.read(repositoryName)).map(Entity::getEntityMetadata).map(EntityMetadata::getId);
    }

    private Optional<Repository> repositoryFor(String repositoryName) {
        return Optional.of(this.repositoryManager).map(rm -> rm.get(repositoryName));
    }

    private Optional<String> formatFor(String repositoryName) {
        return this.formatFor(this.repositoryFor(repositoryName));
    }

    private Optional<String> formatFor(Repository repository) {
        return this.formatFor(Optional.of(repository));
    }

    private Optional<String> formatFor(Optional<Repository> repository) {
        return repository.map(Repository::getFormat).map(Format::getValue);
    }

    private Optional<String> repoTypeFor(String repositoryName) {
        return this.repoTypeFor(this.repositoryFor(repositoryName));
    }

    private Optional<String> repoTypeFor(Repository repository) {
        return this.repoTypeFor(Optional.of(repository));
    }

    private Optional<String> repoTypeFor(Optional<Repository> repository) {
        return repository.map(Repository::getType).map(Type::getValue);
    }
}

