/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.ahc.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.softwarementors.extjs.djn.config.annotations.DirectAction;
import com.softwarementors.extjs.djn.config.annotations.DirectMethod;
import com.sonatype.nexus.ahc.internal.AhcParamsXO;
import com.sonatype.nexus.ahc.internal.AnonymousBlocker;
import com.sonatype.nexus.ahc.internal.ApplicationAnalysisRequest;
import com.sonatype.nexus.ahc.internal.ApplicationAnalyzer;
import com.sonatype.nexus.ahc.internal.ApplicationLocator;
import com.sonatype.nexus.plugins.healthcheck.service.EulaService;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.NotEmpty;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.coreui.ComponentXO;
import org.sonatype.nexus.extdirect.DirectComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentFinder;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.security.SecuritySystem;
import org.sonatype.nexus.security.user.User;
import org.sonatype.nexus.security.user.UserNotFoundException;
import org.sonatype.nexus.validation.Validate;

@Named
@Singleton
@DirectAction(action={"ahc_Component"})
public class AhcComponent
extends DirectComponentSupport {
    private final SecuritySystem securitySystem;
    private final AnonymousBlocker anonymousBlocker;
    private final RepositoryManager repositoryManager;
    private final ApplicationLocator applicationLocator;
    private final ApplicationAnalyzer applicationAnalyzer;
    private final ObjectMapper objectMapper;
    private final Map<String, ComponentFinder> componentFinders;
    private final ComponentFinder defaultComponentFinder;
    private final EulaService eulaService;

    @Inject
    public AhcComponent(SecuritySystem securitySystem, AnonymousBlocker anonymousBlocker, RepositoryManager repositoryManager, ApplicationLocator applicationLocator, ApplicationAnalyzer applicationAnalyzer, EulaService eulaService, ObjectMapper objectMapper, Map<String, ComponentFinder> map) {
        this.securitySystem = (SecuritySystem)Preconditions.checkNotNull((Object)securitySystem);
        this.anonymousBlocker = (AnonymousBlocker)Preconditions.checkNotNull((Object)anonymousBlocker);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.applicationLocator = (ApplicationLocator)((Object)Preconditions.checkNotNull((Object)((Object)applicationLocator)));
        this.applicationAnalyzer = (ApplicationAnalyzer)((Object)Preconditions.checkNotNull((Object)((Object)applicationAnalyzer)));
        this.eulaService = (EulaService)Preconditions.checkNotNull((Object)eulaService);
        this.objectMapper = (ObjectMapper)Preconditions.checkNotNull((Object)objectMapper);
        this.componentFinders = (Map)Preconditions.checkNotNull(map);
        this.defaultComponentFinder = (ComponentFinder)Preconditions.checkNotNull((Object)map.get("default"));
    }

    @DirectMethod
    @Validate
    public void analyzeAsset(@NotEmpty String string, @NotEmpty String string2, @NotEmpty @Email String string3, @NotEmpty String string4, String string5, String string6) {
        this.anonymousBlocker.blockAnonymous();
        Repository repository = this.repositoryManager.get(string);
        Preconditions.checkState((boolean)this.eulaService.isEulaAccepted(), (Object)"The terms of service must be accepted before utilizing Application Health Check functionality");
        Asset asset = this.applicationLocator.locateAsset(repository, string2);
        Preconditions.checkArgument((asset != null ? 1 : 0) != 0, (Object)"Could not locate application");
        Blob blob = this.getBlob(repository, asset);
        ApplicationAnalysisRequest applicationAnalysisRequest = new ApplicationAnalysisRequest(asset.name(), () -> ((Blob)blob).getInputStream(), string3, string4, string6, string5);
        this.applicationAnalyzer.analyzeApplication(applicationAnalysisRequest);
    }

    private Blob getBlob(Repository repository, Asset asset) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (StorageTx storageTx = (StorageTx)((StorageFacet)repository.facet(StorageFacet.class)).txSupplier().get();){
            storageTx.begin();
            return storageTx.requireBlob(asset.blobRef());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @DirectMethod
    @Validate
    public AhcParamsXO getPredefinedValues(@NotEmpty String string) {
        User user;
        this.anonymousBlocker.blockAnonymous();
        AhcParamsXO ahcParamsXO = new AhcParamsXO();
        ahcParamsXO.tosAccepted = this.eulaService.isEulaAccepted();
        Subject subject = SecurityUtils.getSubject();
        if (subject.isAuthenticated()) {
            try {
                user = this.securitySystem.currentUser();
                ahcParamsXO.emailAddress = user.getEmailAddress();
            }
            catch (UserNotFoundException userNotFoundException) {
                this.log.debug("Could not determine email address for current user");
            }
        }
        ahcParamsXO.assetMap = new HashMap<String, String>();
        try {
            user = (ComponentXO)this.objectMapper.readValue(string, ComponentXO.class);
            Collection<Asset> collection = this.getApplicationsFromComponent((ComponentXO)user);
            for (Asset asset : collection) {
                String string2 = EntityHelper.id((Entity)asset).getValue();
                String string3 = this.parseAssetFilename(asset.name());
                if (ahcParamsXO.selectedAsset == null) {
                    ahcParamsXO.selectedAsset = string2;
                    ahcParamsXO.reportLabel = string3;
                }
                ahcParamsXO.assetMap.put(string2, string3);
            }
        }
        catch (IOException iOException) {
            this.log.error(iOException.toString());
        }
        return ahcParamsXO;
    }

    private Collection<Asset> getApplicationsFromComponent(ComponentXO componentXO) {
        Repository repository = this.repositoryManager.get(componentXO.getRepositoryName());
        ComponentFinder componentFinder = this.componentFinders.getOrDefault(componentXO.getFormat(), this.defaultComponentFinder);
        List list = componentFinder.findMatchingComponents((Repository)Preconditions.checkNotNull((Object)repository), componentXO.getId(), componentXO.getGroup(), componentXO.getName(), componentXO.getVersion());
        return this.applicationLocator.locateApplications(repository, (Component)list.get(0));
    }

    @DirectMethod
    public void acceptTermsOfService() {
        this.anonymousBlocker.blockAnonymous();
        this.eulaService.acceptEula();
    }

    private String parseAssetFilename(String string) {
        int n2 = string.lastIndexOf(47);
        if (n2 == -1) {
            return string;
        }
        return string.substring(n2 + 1);
    }

    @DirectMethod
    @Validate
    public boolean containsApplication(@NotEmpty String string) {
        this.anonymousBlocker.blockAnonymous();
        boolean bl2 = false;
        try {
            ComponentXO componentXO = (ComponentXO)this.objectMapper.readValue(string, ComponentXO.class);
            Collection<Asset> collection = this.getApplicationsFromComponent(componentXO);
            bl2 = !collection.isEmpty();
        }
        catch (IOException iOException) {
            this.log.error(iOException.toString());
        }
        return bl2;
    }
}

