/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.ahc.internal;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authz.UnauthenticatedException;
import org.apache.shiro.subject.Subject;
import org.sonatype.nexus.security.SecurityHelper;
import org.sonatype.nexus.security.anonymous.AnonymousConfiguration;
import org.sonatype.nexus.security.anonymous.AnonymousHelper;
import org.sonatype.nexus.security.anonymous.AnonymousManager;

@Named
@Singleton
public class AnonymousBlocker {
    private final SecurityHelper securityHelper;
    private final AnonymousManager anonymousManager;

    @Inject
    public AnonymousBlocker(SecurityHelper securityHelper, AnonymousManager anonymousManager) {
        this.securityHelper = (SecurityHelper)Preconditions.checkNotNull((Object)securityHelper);
        this.anonymousManager = (AnonymousManager)Preconditions.checkNotNull((Object)anonymousManager);
    }

    public void blockAnonymous() {
        if (this.isAnonymous()) {
            throw new UnauthenticatedException("To use Application Health Check, please sign in first.");
        }
    }

    private boolean isAnonymous() {
        Subject subject = this.securityHelper.subject();
        if (AnonymousHelper.isAnonymous((Subject)subject)) {
            return true;
        }
        Object object = subject.getPrincipal();
        if (object == null || !subject.isAuthenticated()) {
            return true;
        }
        AnonymousConfiguration anonymousConfiguration = this.anonymousManager.getConfiguration();
        return Objects.equals(anonymousConfiguration.getUserId(), object);
    }
}

