/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.ahc.internal;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.sonatype.nexus.ahc.internal.ApplicationAnalysisRequest;
import com.sonatype.nexus.ahc.internal.ExecutorServiceFactory;
import com.sonatype.nexus.ahc.internal.ScanFactory;
import com.sonatype.nexus.ahc.internal.ScanSubmitter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
public class ApplicationAnalyzer
extends StateGuardLifecycleSupport {
    private final ScanFactory scanFactory;
    private final ScanSubmitter scanSubmitter;
    private final ExecutorServiceFactory executorServiceFactory;
    private ExecutorService executor;

    @Inject
    public ApplicationAnalyzer(ScanFactory scanFactory, ScanSubmitter scanSubmitter, ExecutorServiceFactory executorServiceFactory) {
        this.scanFactory = (ScanFactory)((Object)Preconditions.checkNotNull((Object)((Object)scanFactory)));
        this.scanSubmitter = (ScanSubmitter)((Object)Preconditions.checkNotNull((Object)((Object)scanSubmitter)));
        this.executorServiceFactory = (ExecutorServiceFactory)Preconditions.checkNotNull((Object)executorServiceFactory);
    }

    protected void doStart() throws Exception {
        this.executor = this.executorServiceFactory.newExecutorService();
    }

    protected void doStop() throws Exception {
        this.executor.shutdownNow();
        this.executor = null;
    }

    @Guarded(by={"STARTED"})
    public Future<?> analyzeApplication(ApplicationAnalysisRequest applicationAnalysisRequest) {
        Preconditions.checkNotNull(applicationAnalysisRequest.getApplicationFile());
        Preconditions.checkNotNull((Object)applicationAnalysisRequest.getApplicationFilename());
        Preconditions.checkNotNull((Object)applicationAnalysisRequest.getReportEmail());
        Preconditions.checkNotNull((Object)applicationAnalysisRequest.getReportPassword());
        this.log.info("Scheduling application {} for analysis on behalf of {}", (Object)applicationAnalysisRequest.getApplicationFilename(), (Object)applicationAnalysisRequest.getReportEmail());
        try {
            return this.executor.submit(() -> this.runAnalysis(applicationAnalysisRequest));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            throw new IllegalStateException("The maximum number of pending application analyses has been reached, please retry in a few minutes", rejectedExecutionException);
        }
    }

    private void runAnalysis(ApplicationAnalysisRequest applicationAnalysisRequest) {
        try {
            this.log.info("Preparing application {} for analysis", (Object)applicationAnalysisRequest.getApplicationFilename());
            this.submit(applicationAnalysisRequest, this.scan(applicationAnalysisRequest));
            this.log.info("Submitted application {} for analysis", (Object)applicationAnalysisRequest.getApplicationFilename());
        }
        catch (Exception exception) {
            this.log.error("Failed to analyze application {}", (Object)applicationAnalysisRequest.getApplicationFilename(), (Object)exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File scan(ApplicationAnalysisRequest applicationAnalysisRequest) throws IOException {
        String string = applicationAnalysisRequest.getApplicationFilename();
        string = string.substring(string.lastIndexOf(47) + 1);
        String string2 = string.substring(string.indexOf(46) + 1);
        Path path = Files.createTempFile("ahc-", "." + string2, new FileAttribute[0]);
        try {
            block17: {
                Throwable throwable = null;
                Object var6_7 = null;
                try {
                    InputStream inputStream = applicationAnalysisRequest.getApplicationFile().get();
                    try {
                        try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
                            ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
                        }
                        if (inputStream == null) break block17;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (inputStream == null) throw throwable;
                        inputStream.close();
                        throw throwable;
                    }
                    inputStream.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            File file = this.scanFactory.scan(path.toFile(), string, Optional.ofNullable(applicationAnalysisRequest.getReportLabel()).orElse(string), applicationAnalysisRequest.getReportPassword(), applicationAnalysisRequest.getProprietaryPackages());
            return file;
        }
        finally {
            if (!path.toFile().delete()) {
                this.log.warn("Failed to delete temporary file for application {}: {}", (Object)applicationAnalysisRequest.getApplicationFilename(), (Object)path);
            }
        }
    }

    private void submit(ApplicationAnalysisRequest applicationAnalysisRequest, File file) throws IOException {
        try {
            this.scanSubmitter.submit(file, applicationAnalysisRequest.getReportEmail());
        }
        finally {
            if (!file.delete()) {
                this.log.warn("Failed to delete temporary scan file for application {}: {}", (Object)applicationAnalysisRequest.getApplicationFilename(), (Object)file);
            }
        }
    }
}

