/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.ahc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.sonatype.nexus.ahc.internal.PermissionChecker;
import com.sonatype.nexus.ahc.internal.ScanFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authz.AuthorizationException;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.DetachedEntityId;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;

@Named
@Singleton
public class ApplicationLocator
extends ComponentSupport {
    private final AssetEntityAdapter assetEntityAdapter;
    private final ScanFactory scanFactory;
    private final PermissionChecker permissionChecker;

    @Inject
    public ApplicationLocator(AssetEntityAdapter assetEntityAdapter, ScanFactory scanFactory, PermissionChecker permissionChecker) {
        this.assetEntityAdapter = (AssetEntityAdapter)Preconditions.checkNotNull((Object)assetEntityAdapter);
        this.scanFactory = (ScanFactory)((Object)Preconditions.checkNotNull((Object)((Object)scanFactory)));
        this.permissionChecker = (PermissionChecker)((Object)Preconditions.checkNotNull((Object)((Object)permissionChecker)));
    }

    public Collection<Asset> locateApplications(Repository repository, Component component) {
        ArrayList arrayList;
        Throwable throwable = null;
        Object var5_5 = null;
        try (StorageTx storageTx = (StorageTx)((StorageFacet)repository.facet(StorageFacet.class)).txSupplier().get();){
            storageTx.begin();
            arrayList = Lists.newArrayList((Iterable)storageTx.browseAssets(component));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return this.locateApplications(repository, arrayList);
    }

    @VisibleForTesting
    Collection<Asset> locateApplications(Repository repository, Iterable<Asset> iterable) {
        Predicate<Asset> predicate = this::notSomeMavenNonArtifact;
        predicate = predicate.and(this::supportedArchiveType);
        predicate = predicate.and(asset -> this.permissionChecker.isAccessPermitted(repository, (Asset)asset));
        return StreamSupport.stream(iterable.spliterator(), false).filter(predicate).collect(Collectors.toList());
    }

    private boolean supportedArchiveType(Asset asset) {
        Set<String> set = this.scanFactory.getSupportedArchiveTypes();
        String string = asset.name().toLowerCase(Locale.ENGLISH);
        return set.stream().anyMatch(string2 -> string.endsWith(String.valueOf('.') + string2));
    }

    private boolean notSomeMavenNonArtifact(Asset asset) {
        if (!asset.attributes().contains("maven2")) {
            return true;
        }
        NestedAttributesMap nestedAttributesMap = asset.attributes().child("maven2");
        return "ARTIFACT".equals(nestedAttributesMap.get("asset_kind")) && !"pom".equals(nestedAttributesMap.get("extension")) && !nestedAttributesMap.get("classifier", (Object)"").toString().endsWith("sources") && !nestedAttributesMap.get("classifier", (Object)"").toString().endsWith("javadoc");
    }

    @Nullable
    public Asset locateAsset(Repository repository, String string) {
        Asset asset;
        Throwable throwable = null;
        Object var5_5 = null;
        try (StorageTx storageTx = (StorageTx)((StorageFacet)repository.facet(StorageFacet.class)).txSupplier().get();){
            storageTx.begin();
            asset = (Asset)this.assetEntityAdapter.read(storageTx.getDb(), (EntityId)new DetachedEntityId(string));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (asset != null && !this.permissionChecker.isAccessPermitted(repository, asset)) {
            throw new AuthorizationException();
        }
        return asset;
    }
}

