/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.ahc.internal;

import com.google.common.base.Preconditions;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.thread.NexusExecutorService;
import org.sonatype.nexus.thread.NexusThreadFactory;

@Named
@Singleton
public class ExecutorServiceFactory {
    private final int maxConcurrentAnalyses;
    private final int maxQueuedAnalyses;

    @Inject
    public ExecutorServiceFactory(@Named(value="${nexus.ahc.maxConcurrentAnalyses:-2}") int n2, @Named(value="${nexus.ahc.maxQueuedAnalyses:-10}") int n3) {
        Preconditions.checkArgument((n2 > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((n3 > 0 ? 1 : 0) != 0);
        this.maxConcurrentAnalyses = n2;
        this.maxQueuedAnalyses = n3;
    }

    public ExecutorService newExecutorService() {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(this.maxConcurrentAnalyses, this.maxConcurrentAnalyses, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.maxQueuedAnalyses), (ThreadFactory)new NexusThreadFactory("ahc", "ahc"));
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        return NexusExecutorService.forCurrentSubject((ExecutorService)threadPoolExecutor);
    }
}

