/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.ahc.internal;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapterManager;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.selector.VariableSource;

@Named
@Singleton
public class PermissionChecker
extends ComponentSupport {
    private final ContentPermissionChecker contentPermissionChecker;
    private final VariableResolverAdapterManager variableResolverAdapterManager;

    @Inject
    public PermissionChecker(ContentPermissionChecker contentPermissionChecker, VariableResolverAdapterManager variableResolverAdapterManager) {
        this.contentPermissionChecker = (ContentPermissionChecker)Preconditions.checkNotNull((Object)contentPermissionChecker);
        this.variableResolverAdapterManager = (VariableResolverAdapterManager)Preconditions.checkNotNull((Object)variableResolverAdapterManager);
    }

    public boolean isAccessPermitted(Repository repository, Asset asset) {
        VariableSource variableSource = this.variableResolverAdapterManager.get(asset.format()).fromAsset(asset);
        return this.contentPermissionChecker.isPermitted(repository.getName(), asset.format(), "read", variableSource);
    }
}

