/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.ahc.internal;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.node.NodeAccess;

@Named
@Singleton
public class ScanSubmitter
extends ComponentSupport {
    private static final ContentType GZIP_CONTENT_TYPE = ContentType.create((String)"application/x-gzip");
    private final String ahcBaseUrl;
    private final Provider<CloseableHttpClient> httpClientProvider;
    private final NodeAccess nodeAccess;

    @Inject
    public ScanSubmitter(@Named(value="${nexus.ahc.url:-https://clm.sonatype.com/}") String string, Provider<CloseableHttpClient> provider, NodeAccess nodeAccess) {
        this.ahcBaseUrl = (String)Preconditions.checkNotNull((Object)string);
        this.log.debug("Using AHC service at {}", (Object)string);
        this.httpClientProvider = (Provider)Preconditions.checkNotNull(provider);
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
    }

    public void submit(File file, String string) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (CloseableHttpClient closeableHttpClient = (CloseableHttpClient)this.httpClientProvider.get();){
            URI uRI;
            block21: {
                uRI = UriBuilder.fromUri((String)this.ahcBaseUrl).path("rest/ahc/scan").path(string).queryParam("clientType", new Object[]{"AHC"}).queryParam("integrator", new Object[]{"NexusRepo"}).queryParam("instanceId", new Object[]{this.nodeAccess.getId()}).build(new Object[0]);
                this.log.debug("Submitting application hashes {} to {}", (Object)file, (Object)uRI);
                HttpPut httpPut = new HttpPut(uRI);
                httpPut.setEntity((HttpEntity)new FileEntity(file, GZIP_CONTENT_TYPE));
                Throwable throwable2 = null;
                Object var9_12 = null;
                try (CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpPut);){
                    String string2;
                    this.log.debug("AHC service responded with {}", (Object)closeableHttpResponse.getStatusLine());
                    if (closeableHttpResponse.getStatusLine().getStatusCode() < 300) break block21;
                    try {
                        string2 = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
                    }
                    catch (IOException iOException) {
                        string2 = null;
                    }
                    if (string2 == null) {
                        string2 = closeableHttpResponse.getStatusLine().getReasonPhrase();
                    }
                    throw new HttpResponseException(closeableHttpResponse.getStatusLine().getStatusCode(), string2);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            this.log.debug("Submitted application hashes {} to {}", (Object)file, (Object)uRI);
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }
}

