/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.ahc.internal.scan;

import com.sonatype.insight.scan.model.ScanConfiguration;
import com.sonatype.insight.scan.model.ScanSummary;
import com.sonatype.nexus.ahc.internal.scan.n;
import com.sonatype.nexus.ahc.internal.scan.o;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class p
implements o {
    private final Logger a;

    @Inject
    public p() {
        this(LoggerFactory.getLogger(p.class));
    }

    public p(Logger logger) {
        this.a = logger;
    }

    @Override
    public void a(n n2) {
        ScanSummary scanSummary = n2.a().getSummary();
        ScanConfiguration scanConfiguration = n2.a().getConfiguration();
        this.a(scanSummary);
        if (scanConfiguration.getBoolean(true, new String[]{"operatingSystem"})) {
            this.b(scanSummary);
        }
        if (scanConfiguration.getBoolean(true, new String[]{"procArch"})) {
            this.c(scanSummary);
        }
        if (scanConfiguration.getBoolean(true, new String[]{"ipAddresses"})) {
            this.d(scanSummary);
        }
        if (scanConfiguration.getBoolean(true, new String[]{"jreInfo"})) {
            this.e(scanSummary);
        }
    }

    private InputStream a() {
        InputStream inputStream = this.getClass().getResourceAsStream("/com/sonatype/insight/client.properties");
        if (inputStream == null) {
            inputStream = this.getClass().getResourceAsStream("/com/sonatype/insight/scan/scanner.properties");
        }
        return inputStream;
    }

    private void a(ScanSummary scanSummary) {
        try (InputStream inputStream = this.a();){
            if (inputStream == null) {
                this.a.warn("Could not locate client info descriptor");
                return;
            }
            Properties properties = new Properties();
            properties.load(inputStream);
            scanSummary.setScannerDriver(properties.getProperty("driver"));
            scanSummary.setScannerVersion(properties.getProperty("version"));
            scanSummary.putClientInfo("insight.scannerDriver", scanSummary.getScannerDriver());
            scanSummary.putClientInfo("insight.scannerVersion", scanSummary.getScannerVersion());
        }
        catch (IOException iOException) {
            this.a.warn("Could not read client info descriptor", (Throwable)iOException);
        }
    }

    private void b(ScanSummary scanSummary) {
        String string = System.getProperty("os.name");
        scanSummary.setOperatingSystem(string);
        scanSummary.putClientInfo("os.name", string);
    }

    private void c(ScanSummary scanSummary) {
        String string = System.getProperty("os.arch");
        scanSummary.setProcessorArchitecture(string);
        scanSummary.putClientInfo("os.arch", string);
    }

    private void d(ScanSummary scanSummary) {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            scanSummary.setHostName(inetAddress.getHostName());
            scanSummary.putClientInfo("network.hostName", scanSummary.getHostName());
            StringBuilder stringBuilder = new StringBuilder(128);
            for (InetAddress inetAddress2 : InetAddress.getAllByName(inetAddress.getHostName())) {
                if (inetAddress2.isLoopbackAddress()) continue;
                scanSummary.addIpAddress(inetAddress2.getHostAddress());
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(inetAddress2.getHostAddress());
            }
            scanSummary.putClientInfo("network.ipAddress", stringBuilder.toString());
        }
        catch (UnknownHostException unknownHostException) {
            this.a.debug("Could not determine IP address of localhost", (Throwable)unknownHostException);
        }
    }

    private void e(ScanSummary scanSummary) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)System.getProperties());
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            if (string.equals("java.version") || string.startsWith("java.vm.") || string.startsWith("java.vendor.") || string.startsWith("java.specification.") || string.startsWith("java.runtime.")) continue;
            iterator.remove();
        }
        scanSummary.putClientInfo(properties);
    }
}

