/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.crypto;

import de.schlichtherle.truezip.io.DecoratingOutputStream;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.InvalidCipherTextException;

@NotThreadSafe
public class CipherOutputStream
extends DecoratingOutputStream {
    @Nullable
    protected BufferedBlockCipher cipher;
    private byte[] cipherOut = new byte[0];

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public CipherOutputStream(@CheckForNull @WillCloseWhenClosed OutputStream outputStream, @CheckForNull BufferedBlockCipher bufferedBlockCipher) {
        super(outputStream);
        this.cipher = bufferedBlockCipher;
    }

    private void checkOpen() throws IOException {
        if (null == this.cipher) {
            throw new IOException("cipher output stream is not in open state");
        }
    }

    @Override
    public void write(int n2) throws IOException {
        this.checkOpen();
        int n3 = this.cipher.getUpdateOutputSize(1);
        byte[] byArray = this.cipherOut;
        if (n3 > byArray.length) {
            this.cipherOut = byArray = new byte[n3];
        }
        if ((n3 = this.cipher.processByte((byte)n2, byArray, 0)) > 0) {
            this.delegate.write(byArray, 0, n3);
        }
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.checkOpen();
        int n4 = this.cipher.getUpdateOutputSize(n3);
        byte[] byArray2 = this.cipherOut;
        if (n4 > byArray2.length) {
            this.cipherOut = byArray2 = new byte[n4];
        }
        n4 = this.cipher.processBytes(byArray, n2, n3, byArray2, 0);
        this.delegate.write(byArray2, 0, n4);
    }

    @OverridingMethodsMustInvokeSuper
    protected void finish() throws IOException {
        this.checkOpen();
        int n2 = this.cipher.getOutputSize(0);
        byte[] byArray = this.cipherOut;
        if (n2 > byArray.length) {
            this.cipherOut = byArray = new byte[n2];
        }
        try {
            n2 = this.cipher.doFinal(byArray, 0);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new IOException(invalidCipherTextException);
        }
        this.delegate.write(byArray, 0, n2);
    }

    @Override
    public void close() throws IOException {
        if (null != this.cipher) {
            this.finish();
            this.cipher = null;
        }
        this.delegate.close();
    }
}

