/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.entry;

import de.schlichtherle.truezip.util.QuotedUriSyntaxException;
import de.schlichtherle.truezip.util.UriBuilder;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class EntryName
implements Serializable,
Comparable<EntryName> {
    private static final long serialVersionUID = 2927354934726235478L;
    public static final String SEPARATOR = "/";
    public static final char SEPARATOR_CHAR = '/';
    @SuppressWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
    private URI uri;

    @Deprecated
    public static EntryName create(String string) {
        try {
            return new EntryName(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
    }

    @Deprecated
    public static EntryName create(URI uRI) {
        try {
            return new EntryName(uRI);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
    }

    @Deprecated
    public EntryName(String string) throws URISyntaxException {
        this.parse(new URI(string));
    }

    public EntryName(URI uRI) throws URISyntaxException {
        this.parse(uRI);
    }

    public EntryName(EntryName entryName, EntryName entryName2) {
        URI uRI = entryName.uri;
        String string = uRI.getRawPath();
        URI uRI2 = entryName2.uri;
        try {
            this.uri = string.isEmpty() ? uRI2 : (string.endsWith(SEPARATOR) ? uRI.resolve(uRI2) : (uRI2.getPath().isEmpty() ? new UriBuilder(uRI, true).query(uRI2.getRawQuery()).getUri() : new UriBuilder(true).path(string + '/').getUri().resolve(uRI2)));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new AssertionError((Object)uRISyntaxException);
        }
        assert (this.invariants());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.uri.toString());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            this.parse(new URI(objectInputStream.readObject().toString()));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw (InvalidObjectException)new InvalidObjectException(uRISyntaxException.toString()).initCause(uRISyntaxException);
        }
    }

    private void parse(URI uRI) throws URISyntaxException {
        if (uRI.isAbsolute()) {
            throw new QuotedUriSyntaxException(uRI, "Scheme component defined.");
        }
        if (null != uRI.getRawAuthority()) {
            throw new QuotedUriSyntaxException(uRI, "Authority component defined.");
        }
        if (null == uRI.getRawPath()) {
            throw new QuotedUriSyntaxException(uRI, "Path component undefined.");
        }
        if (null != uRI.getRawFragment()) {
            throw new QuotedUriSyntaxException(uRI, "Fragment component defined.");
        }
        this.uri = uRI;
        assert (this.invariants());
    }

    private boolean invariants() {
        assert (null != this.toUri());
        assert (!this.toUri().isAbsolute());
        assert (null != this.toUri().getRawPath());
        assert (null == this.toUri().getRawFragment());
        return true;
    }

    public final URI toUri() {
        return this.uri;
    }

    @Deprecated
    public final URI getUri() {
        return this.uri;
    }

    public final String getPath() {
        return this.uri.getPath();
    }

    @CheckForNull
    public final String getQuery() {
        return this.uri.getQuery();
    }

    @CheckForNull
    public final String getFragment() {
        return this.uri.getFragment();
    }

    public final boolean equals(@CheckForNull Object object) {
        return this == object || object instanceof EntryName && this.uri.equals(((EntryName)object).uri);
    }

    @Override
    public final int compareTo(EntryName entryName) {
        return this.uri.compareTo(entryName.uri);
    }

    public final int hashCode() {
        return this.uri.hashCode();
    }

    public final String toString() {
        return this.uri.toString();
    }
}

