/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file.swing;

import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.swing.TDecoratingFileSystemView;
import de.schlichtherle.truezip.file.swing.TFileView;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.MessageFormat;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;

public class TFileSystemView
extends TDecoratingFileSystemView {
    @CheckForNull
    private TArchiveDetector archiveDetector;

    public TFileSystemView() {
        this(FileSystemView.getFileSystemView(), null);
    }

    public TFileSystemView(FileSystemView fileSystemView) {
        this(fileSystemView, null);
    }

    public TFileSystemView(FileSystemView fileSystemView, @CheckForNull TArchiveDetector tArchiveDetector) {
        super(fileSystemView);
        this.archiveDetector = tArchiveDetector;
    }

    @CheckForNull
    public TArchiveDetector getArchiveDetector() {
        return this.archiveDetector;
    }

    public void setArchiveDetector(@CheckForNull TArchiveDetector tArchiveDetector) {
        this.archiveDetector = tArchiveDetector;
    }

    protected TFile wrap(File file) {
        if (null == file) {
            return null;
        }
        return file instanceof TFile ? (TFile)file : new TFile(file, this.getArchiveDetector());
    }

    protected File unwrap(File file) {
        return file instanceof TFile ? ((TFile)file).getFile() : file;
    }

    @Override
    public boolean isRoot(File file) {
        return this.delegate.isRoot(this.unwrap(file));
    }

    @Override
    public Boolean isTraversable(File file) {
        TFile tFile = this.wrap(file);
        return null != tFile ? Boolean.valueOf(tFile.isDirectory()) : this.delegate.isTraversable(this.unwrap(file));
    }

    @Override
    public String getSystemDisplayName(File file) {
        TFile tFile = this.wrap(file);
        if (tFile.isArchive() || tFile.isEntry()) {
            return tFile.getName();
        }
        return this.delegate.getSystemDisplayName(this.unwrap(file));
    }

    @Override
    public String getSystemTypeDescription(File file) {
        TFile tFile = this.wrap(file);
        String string = TFileView.typeDescription((File)tFile);
        if (string != null) {
            return string;
        }
        return this.delegate.getSystemTypeDescription(this.unwrap(file));
    }

    @Override
    public Icon getSystemIcon(File file) {
        TFile tFile = this.wrap(file);
        Icon icon = TFileView.icon((File)tFile);
        if (null != icon) {
            return icon;
        }
        File file2 = this.unwrap(file);
        return file2.exists() ? this.delegate.getSystemIcon(file2) : null;
    }

    @Override
    public boolean isParent(File file, File file2) {
        return this.delegate.isParent(this.wrap(file), this.wrap(file2)) || this.delegate.isParent(this.unwrap(file), this.unwrap(file2));
    }

    @Override
    public File getChild(File file, String string) {
        TFile tFile = this.wrap(file);
        if (tFile.isArchive() || tFile.isEntry()) {
            return this.createFileObject(this.delegate.getChild(tFile, string));
        }
        return this.createFileObject(this.delegate.getChild(this.unwrap(file), string));
    }

    @Override
    public boolean isFileSystem(File file) {
        return this.delegate.isFileSystem(this.unwrap(file));
    }

    @Override
    public File createNewFolder(File file) throws IOException {
        TFile tFile = this.wrap(file);
        if (tFile.isArchive() || tFile.isEntry()) {
            TFile tFile2 = new TFile((File)tFile, UIManager.getString(TFile.separatorChar == '\\' ? "FileChooser.win32.newFolder" : "FileChooser.other.newFolder"), this.getArchiveDetector());
            int n2 = 2;
            while (!tFile2.mkdirs()) {
                if (n2 > 100) {
                    throw new IOException(tFile + ": Could not create new directory entry!");
                }
                tFile2 = new TFile((File)tFile, MessageFormat.format(UIManager.getString(TFile.separatorChar == '\\' ? "FileChooser.win32.newFolder.subsequent" : "FileChooser.other.newFolder.subsequent"), n2), this.getArchiveDetector());
                ++n2;
            }
            return tFile2;
        }
        return this.createFileObject(this.delegate.createNewFolder(this.unwrap(file)));
    }

    @Override
    public boolean isHiddenFile(File file) {
        return this.delegate.isHiddenFile(this.unwrap(file));
    }

    @Override
    public boolean isFileSystemRoot(File file) {
        return this.delegate.isFileSystemRoot(this.unwrap(file));
    }

    @Override
    public boolean isDrive(File file) {
        return this.delegate.isDrive(this.unwrap(file));
    }

    @Override
    public boolean isFloppyDrive(File file) {
        return this.delegate.isFloppyDrive(this.unwrap(file));
    }

    @Override
    public boolean isComputerNode(File file) {
        return this.delegate.isComputerNode(this.unwrap(file));
    }

    @Override
    public File createFileObject(File file, String string) {
        return this.createFileObject(this.delegate.createFileObject(file, string));
    }

    @Override
    public File createFileObject(String string) {
        return this.createFileObject(this.delegate.createFileObject(string));
    }

    @Nullable
    public File createFileObject(@CheckForNull File file) {
        if (null == file) {
            return null;
        }
        TFile tFile = this.wrap(file);
        return tFile.isArchive() || tFile.isEntry() ? tFile : this.unwrap(file);
    }

    @Override
    public File[] getFiles(File file, final boolean bl2) {
        TFile tFile = this.wrap(file);
        if (tFile.isArchive() || tFile.isEntry()) {
            class Filter
            implements FileFilter {
                Filter() {
                }

                @Override
                public boolean accept(File file) {
                    return !bl2 || !TFileSystemView.this.isHiddenFile(file);
                }
            }
            File[] fileArray = tFile.listFiles(new Filter());
            return null == fileArray ? new TFile[]{} : fileArray;
        }
        File[] fileArray = this.delegate.getFiles(this.unwrap(file), bl2);
        int n2 = fileArray.length;
        while (--n2 >= 0) {
            fileArray[n2] = this.createFileObject(fileArray[n2]);
        }
        return fileArray;
    }

    @Override
    public File getParentDirectory(File file) {
        TFile tFile = this.wrap(file);
        if (tFile.isEntry()) {
            return this.createFileObject(tFile.getParentFile());
        }
        return this.createFileObject(this.delegate.getParentDirectory(this.unwrap(file)));
    }
}

