/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file.swing;

import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public final class TFileTreeModel
implements TreeModel {
    private final Map<TFile, TFile[]> cache = new HashMap<TFile, TFile[]>();
    @CheckForNull
    private final TFile root;
    @CheckForNull
    private final FileFilter filter;
    private final Comparator<? super TFile> comparator;
    private final EventListenerList listeners = new EventListenerList();

    public TFileTreeModel(@CheckForNull TFile tFile, @CheckForNull FileFilter fileFilter, Comparator<? super TFile> comparator) {
        if (null != tFile && 0 != comparator.compare(tFile, tFile)) {
            throw new IllegalArgumentException();
        }
        if (null == comparator) {
            throw new NullPointerException();
        }
        this.root = tFile;
        this.filter = fileFilter;
        this.comparator = comparator;
    }

    @Override
    public TFile getRoot() {
        return this.root;
    }

    @Override
    public TFile getChild(Object object, int n2) {
        return this.getChildren((TFile)object)[n2];
    }

    @Override
    public int getChildCount(Object object) {
        TFile[] tFileArray = this.getChildren((TFile)object);
        return null == tFileArray ? 0 : tFileArray.length;
    }

    @Override
    public boolean isLeaf(Object object) {
        return !((TFile)object).isDirectory();
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        if (object == null || object2 == null) {
            return -1;
        }
        TFile[] tFileArray = this.getChildren((TFile)object);
        if (null == tFileArray) {
            return -1;
        }
        int n2 = tFileArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!tFileArray[i2].equals(object2)) continue;
            return i2;
        }
        return -1;
    }

    @Nullable
    private TFile[] getChildren(TFile tFile) {
        assert (tFile != null);
        TFile[] tFileArray = this.cache.get(tFile);
        if (null == tFileArray) {
            if (this.cache.containsKey(tFile)) {
                return null;
            }
            tFileArray = tFile.listFiles(this.filter);
            this.cache.put(tFile, tFileArray);
            if (null != tFileArray) {
                Arrays.sort(tFileArray, this.comparator);
            }
        }
        return tFileArray;
    }

    @Nullable
    TreePath newTreePath(TFile tFile) {
        Object[] objectArray = this.newPath(tFile);
        return null == objectArray ? null : new TreePath(objectArray);
    }

    @Nullable
    private TFile[] newPath(TFile tFile) {
        if (null == this.root) {
            return null;
        }
        return this.newPath(tFile, 1);
    }

    @Nullable
    private TFile[] newPath(@CheckForNull TFile tFile, int n2) {
        TFile[] tFileArray;
        assert (this.root != null);
        if (this.root.equals(tFile)) {
            tFileArray = new TFile[n2];
            tFileArray[0] = this.root;
        } else if (null != tFile) {
            tFileArray = this.newPath(tFile.getParentFile(), n2 + 1);
            if (tFileArray != null) {
                tFileArray[tFileArray.length - n2] = tFile;
            }
        } else {
            tFileArray = null;
        }
        return tFileArray;
    }

    public boolean createNewFile(TFile tFile) throws IOException {
        if (!tFile.createNewFile()) {
            return false;
        }
        this.nodeInserted(tFile);
        return true;
    }

    public void mkdir(TFile tFile, boolean bl2) throws IOException {
        tFile.mkdir(bl2);
        this.nodeInserted(tFile);
    }

    public void cp(@WillClose InputStream inputStream, TFile tFile) throws IOException {
        TFile.cp(inputStream, (File)tFile);
        this.nodeInsertedOrStructureChanged(tFile);
    }

    public void cp(TFile tFile, TFile tFile2) throws IOException {
        TFile.cp((File)tFile, (File)tFile2);
        this.nodeInsertedOrStructureChanged(tFile2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cp_r(TFile tFile, TFile tFile2) throws IOException {
        try {
            tFile.cp_r(tFile2);
        }
        finally {
            this.nodeInsertedOrStructureChanged(tFile2);
        }
    }

    public void cp_p(TFile tFile, TFile tFile2) throws IOException {
        TFile.cp_p(tFile, tFile2);
        this.nodeInsertedOrStructureChanged(tFile2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cp_rp(TFile tFile, TFile tFile2) throws IOException {
        try {
            tFile.cp_rp(tFile2);
        }
        finally {
            this.nodeInsertedOrStructureChanged(tFile2);
        }
    }

    public void mv(TFile tFile, TFile tFile2) throws IOException {
        tFile.mv(tFile2);
        this.nodeRemoved(tFile);
        this.nodeInserted(tFile2);
    }

    public void rm(TFile tFile) throws IOException {
        TFile.rm(tFile);
        this.nodeRemoved(tFile);
    }

    public void rm_r(TFile tFile) throws IOException {
        TFile.rm_r(tFile);
        this.nodeRemoved(tFile);
    }

    public void nodeInsertedOrStructureChanged(TFile tFile) {
        if (tFile == null) {
            throw new NullPointerException();
        }
        if (this.cache.containsKey(tFile)) {
            this.structureChanged(tFile);
        } else {
            this.nodeInserted(tFile);
        }
    }

    public void nodeInserted(TFile tFile) {
        if (this.cache.containsKey(tFile)) {
            return;
        }
        TFile tFile2 = tFile.getParentFile();
        this.forget(tFile2, false);
        int n2 = this.getIndexOfChild(tFile2, tFile);
        if (n2 == -1) {
            return;
        }
        this.fireTreeNodesInserted(new TreeModelEvent((Object)this, this.newTreePath(tFile2), new int[]{n2}, (Object[])new TFile[]{tFile}));
    }

    public void nodeChanged(TFile tFile) {
        TFile tFile2 = tFile.getParentFile();
        int n2 = this.getIndexOfChild(tFile2, tFile);
        if (n2 == -1) {
            return;
        }
        this.fireTreeNodesChanged(new TreeModelEvent((Object)this, this.newTreePath(tFile2), new int[]{n2}, (Object[])new TFile[]{tFile}));
    }

    public void nodeRemoved(TFile tFile) {
        TFile tFile2 = tFile.getParentFile();
        int n2 = this.getIndexOfChild(tFile2, tFile);
        if (n2 == -1) {
            return;
        }
        this.forget(tFile, true);
        this.forget(tFile2, false);
        this.getChildren(tFile2);
        this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, this.newTreePath(tFile2), new int[]{n2}, (Object[])new TFile[]{tFile}));
    }

    public void refresh() {
        this.cache.clear();
        if (this.root != null) {
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, this.newTreePath(this.root), null, null));
        }
    }

    public final void refresh(TFile tFile) {
        this.structureChanged(tFile);
    }

    public void structureChanged(TFile tFile) {
        if (tFile == null) {
            throw new NullPointerException();
        }
        this.forget(tFile, true);
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, this.newTreePath(tFile), null, null));
    }

    void forget(TFile tFile) {
        this.forget(tFile, true);
    }

    private void forget(@Nullable TFile tFile, boolean bl2) {
        TFile[] tFileArray = this.cache.remove(tFile);
        if (null != tFileArray && bl2) {
            int n2 = tFileArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.forget(tFileArray[i2], bl2);
            }
        }
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.add(TreeModelListener.class, treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.remove(TreeModelListener.class, treeModelListener);
    }

    protected void fireTreeNodesChanged(TreeModelEvent treeModelEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(TreeModelListener.class);
        int n2 = eventListenerArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ((TreeModelListener)eventListenerArray[i2]).treeNodesChanged(treeModelEvent);
        }
    }

    protected void fireTreeNodesInserted(TreeModelEvent treeModelEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(TreeModelListener.class);
        int n2 = eventListenerArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ((TreeModelListener)eventListenerArray[i2]).treeNodesInserted(treeModelEvent);
        }
    }

    protected void fireTreeNodesRemoved(TreeModelEvent treeModelEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(TreeModelListener.class);
        int n2 = eventListenerArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ((TreeModelListener)eventListenerArray[i2]).treeNodesRemoved(treeModelEvent);
        }
    }

    protected void fireTreeStructureChanged(TreeModelEvent treeModelEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(TreeModelListener.class);
        int n2 = eventListenerArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ((TreeModelListener)eventListenerArray[i2]).treeStructureChanged(treeModelEvent);
        }
    }
}

