/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file.swing;

import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.swing.TDecoratingFileView;
import de.schlichtherle.truezip.file.swing.TNullFileView;
import java.io.File;
import java.util.ResourceBundle;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.filechooser.FileView;

public class TFileView
extends TDecoratingFileView {
    private static final String CLASS_NAME = TFileView.class.getName();
    private static final ResourceBundle resources = ResourceBundle.getBundle(CLASS_NAME);

    public TFileView(@CheckForNull FileView fileView) {
        super(null != fileView ? fileView : new TNullFileView());
    }

    @Override
    @Nullable
    public String getTypeDescription(File file) {
        String string = TFileView.typeDescription(file);
        return string != null ? string : this.delegate.getTypeDescription(file);
    }

    @Nullable
    static String typeDescription(File file) {
        return file instanceof TFile ? TFileView.typeDescription((TFile)file) : null;
    }

    @Nullable
    private static String typeDescription(TFile tFile) {
        if (TFileView.isTrueArchive(tFile)) {
            return resources.getString("archiveFile");
        }
        if (TFileView.isTrueEntry(tFile)) {
            return tFile.isDirectory() ? resources.getString("archiveDirectoryEntry") : (tFile.isFile() ? resources.getString("archiveFileEntry") : null);
        }
        return null;
    }

    @Override
    @Nullable
    public Icon getIcon(File file) {
        Icon icon = TFileView.icon(file);
        return null != icon ? icon : this.delegate.getIcon(file);
    }

    @Nullable
    static Icon icon(File file) {
        return file instanceof TFile ? TFileView.icon((TFile)file) : null;
    }

    @Nullable
    private static Icon icon(TFile tFile) {
        if (TFileView.isTrueArchive(tFile)) {
            return UIManager.getIcon("FileView.directoryIcon");
        }
        if (TFileView.isTrueEntry(tFile)) {
            return tFile.isDirectory() ? UIManager.getIcon("FileView.directoryIcon") : (tFile.isFile() ? UIManager.getIcon("FileView.fileIcon") : null);
        }
        return null;
    }

    private static boolean isTrueArchive(TFile tFile) {
        return tFile.isArchive() && tFile.isDirectory();
    }

    private static boolean isTrueEntry(TFile tFile) {
        if (!tFile.isEntry()) {
            return false;
        }
        TFile tFile2 = tFile.getParentFile();
        assert (tFile2 != null) : "An archive entry must always name a parent!";
        return tFile2.isDirectory();
    }

    @Override
    @Nullable
    public Boolean isTraversable(File file) {
        return file instanceof TFile ? Boolean.valueOf(((TFile)file).isDirectory()) : this.delegate.isTraversable(file);
    }
}

