/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.entry.EntryContainer;
import de.schlichtherle.truezip.fs.FsArchiveDriver;
import de.schlichtherle.truezip.fs.FsArchiveEntry;
import de.schlichtherle.truezip.fs.FsArchiveFileSystemException;
import de.schlichtherle.truezip.fs.FsArchiveFileSystemOperation;
import de.schlichtherle.truezip.fs.FsCovariantEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsOutputOptions;
import de.schlichtherle.truezip.fs.FsReadOnlyArchiveFileSystem;
import de.schlichtherle.truezip.io.Paths;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.HashMaps;
import de.schlichtherle.truezip.util.Link;
import java.io.CharConversionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
class FsArchiveFileSystem<E extends FsArchiveEntry>
implements Iterable<FsCovariantEntry<E>> {
    private static final String ROOT_PATH = FsEntryName.ROOT.getPath();
    private final Splitter splitter = new Splitter();
    private final FsArchiveDriver<E> factory;
    private final EntryTable<E> master;
    private boolean touched;
    @CheckForNull
    private TouchListener touchListener;

    static <E extends FsArchiveEntry> FsArchiveFileSystem<E> newEmptyFileSystem(FsArchiveDriver<E> fsArchiveDriver) {
        return new FsArchiveFileSystem<E>(fsArchiveDriver);
    }

    private FsArchiveFileSystem(FsArchiveDriver<E> fsArchiveDriver) {
        this.factory = fsArchiveDriver;
        E e2 = this.newEntry(ROOT_PATH, Entry.Type.DIRECTORY, FsOutputOptions.NONE, null);
        long l2 = System.currentTimeMillis();
        for (Entry.Access access : Entry.ALL_ACCESS_SET) {
            e2.setTime(access, l2);
        }
        EntryTable entryTable = new EntryTable(HashMaps.initialCapacity(47));
        entryTable.add(ROOT_PATH, e2);
        this.master = entryTable;
        this.touched = true;
    }

    static <E extends FsArchiveEntry> FsArchiveFileSystem<E> newPopulatedFileSystem(FsArchiveDriver<E> fsArchiveDriver, @WillNotClose EntryContainer<E> entryContainer, @CheckForNull Entry entry, boolean bl2) throws FsArchiveFileSystemException {
        return bl2 ? new FsReadOnlyArchiveFileSystem<E>(entryContainer, fsArchiveDriver, entry) : new FsArchiveFileSystem<E>(fsArchiveDriver, entryContainer, entry);
    }

    FsArchiveFileSystem(FsArchiveDriver<E> fsArchiveDriver, @WillNotClose EntryContainer<E> entryContainer, @CheckForNull Entry entry) throws FsArchiveFileSystemException {
        this.factory = fsArchiveDriver;
        EntryTable<FsArchiveEntry> entryTable = new EntryTable<FsArchiveEntry>(HashMaps.initialCapacity(entryContainer.getSize() + 47));
        ArrayList<String> arrayList = new ArrayList<String>(entryContainer.getSize());
        Paths.Normalizer normalizer = new Paths.Normalizer('/');
        for (FsArchiveEntry object : entryContainer) {
            String string = Paths.cutTrailingSeparators(normalizer.normalize(object.getName().replace('\\', '/')), '/');
            entryTable.add(string, object);
            if (!FsArchiveFileSystem.isValidEntryName(string)) continue;
            arrayList.add(string);
        }
        entryTable.add(ROOT_PATH, (FsArchiveEntry)this.newEntry(ROOT_PATH, Entry.Type.DIRECTORY, FsOutputOptions.NONE, entry));
        this.master = entryTable;
        for (String string : arrayList) {
            this.fix(string);
        }
    }

    private static boolean isValidEntryName(String string) {
        return !Paths.isAbsolute(string, '/') && !"../".startsWith(string.substring(0, Math.min(3, string.length())));
    }

    private void fix(String string) throws FsArchiveFileSystemException {
        if (Paths.isRoot(string)) {
            return;
        }
        this.splitter.split(string);
        String string2 = this.splitter.getParentPath();
        String string3 = this.splitter.getMemberName();
        FsCovariantEntry<E> fsCovariantEntry = this.master.get(string2);
        if (null == fsCovariantEntry || !fsCovariantEntry.isType(Entry.Type.DIRECTORY)) {
            fsCovariantEntry = this.master.add(string2, this.newCheckedEntry(string2, Entry.Type.DIRECTORY, FsOutputOptions.NONE, null));
        }
        fsCovariantEntry.add(string3);
        this.fix(string2);
    }

    boolean isReadOnly() {
        return false;
    }

    private void touch() throws IOException {
        if (this.touched) {
            return;
        }
        TouchListener touchListener = this.touchListener;
        if (null != touchListener) {
            touchListener.preTouch();
        }
        this.touched = true;
    }

    final TouchListener getTouchListener() {
        return this.touchListener;
    }

    final void setTouchListener(TouchListener touchListener) {
        if (null != touchListener && null != this.touchListener) {
            throw new IllegalStateException("The touch listener has already been set!");
        }
        this.touchListener = touchListener;
    }

    int getSize() {
        return this.master.getSize();
    }

    @Override
    public Iterator<FsCovariantEntry<E>> iterator() {
        return this.master.iterator();
    }

    @Nullable
    final FsCovariantEntry<E> getEntry(FsEntryName fsEntryName) {
        FsCovariantEntry<E> fsCovariantEntry = this.master.get(fsEntryName.getPath());
        return null == fsCovariantEntry ? null : fsCovariantEntry.clone(this.factory);
    }

    private E newEntry(String string, Entry.Type type, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) {
        assert (null != type);
        assert (!Paths.isRoot(string) || Entry.Type.DIRECTORY == type);
        try {
            return this.factory.newEntry(string, type, entry, bitField);
        }
        catch (CharConversionException charConversionException) {
            throw new AssertionError((Object)charConversionException);
        }
    }

    private E newCheckedEntry(String string, Entry.Type type, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) throws FsArchiveFileSystemException {
        assert (null != type);
        assert (!Paths.isRoot(string) || Entry.Type.DIRECTORY == type);
        try {
            this.factory.assertEncodable(string);
            return this.factory.newEntry(string, type, entry, bitField);
        }
        catch (CharConversionException charConversionException) {
            throw new FsArchiveFileSystemException(string, charConversionException);
        }
    }

    FsArchiveFileSystemOperation<E> mknod(FsEntryName fsEntryName, Entry.Type type, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) throws FsArchiveFileSystemException {
        if (null == type) {
            throw new NullPointerException();
        }
        if (Entry.Type.FILE != type && Entry.Type.DIRECTORY != type) {
            throw new FsArchiveFileSystemException(fsEntryName, "only FILE and DIRECTORY entries are supported");
        }
        String string = fsEntryName.getPath();
        FsCovariantEntry<E> fsCovariantEntry = this.master.get(string);
        if (null != fsCovariantEntry) {
            if (!fsCovariantEntry.isType(Entry.Type.FILE)) {
                throw new FsArchiveFileSystemException(fsEntryName, "only files can get replaced");
            }
            if (Entry.Type.FILE != type) {
                throw new FsArchiveFileSystemException(fsEntryName, "entry exists as a different type");
            }
            if (bitField.get(FsOutputOption.EXCLUSIVE)) {
                throw new FsArchiveFileSystemException(fsEntryName, "entry exists already");
            }
        }
        while (entry instanceof FsCovariantEntry) {
            entry = ((FsCovariantEntry)entry).get(type);
        }
        return new PathLink(string, type, bitField, entry);
    }

    void unlink(FsEntryName fsEntryName) throws IOException {
        int n2;
        String string = fsEntryName.getPath();
        FsCovariantEntry<E> fsCovariantEntry = this.master.get(string);
        if (null == fsCovariantEntry) {
            throw new FsArchiveFileSystemException(fsEntryName, "archive entry does not exist");
        }
        if (fsCovariantEntry.isType(Entry.Type.DIRECTORY) && 0 != (n2 = fsCovariantEntry.getMembers().size())) {
            throw new FsArchiveFileSystemException(fsEntryName, String.format("directory not empty - contains %d member(s)", n2));
        }
        if (fsEntryName.isRoot()) {
            return;
        }
        this.touch();
        this.master.remove(string);
        Object object = fsCovariantEntry.getEntry();
        for (Entry.Size enum_ : Entry.ALL_SIZE_SET) {
            object.setSize(enum_, -1L);
        }
        for (Entry.Access access : Entry.ALL_ACCESS_SET) {
            object.setTime(access, -1L);
        }
        this.splitter.split(string);
        object = this.splitter.getParentPath();
        FsCovariantEntry<E> fsCovariantEntry2 = this.master.get((String)object);
        assert (null != fsCovariantEntry2) : "The parent directory of \"" + fsEntryName.toString() + "\" is missing - archive file system is corrupted!";
        boolean bl2 = fsCovariantEntry2.remove(this.splitter.getMemberName());
        assert (bl2) : "The parent directory of \"" + fsEntryName.toString() + "\" does not contain this entry - archive file system is corrupted!";
        Object e2 = fsCovariantEntry2.get(Entry.Type.DIRECTORY);
        if (-1L != e2.getTime(Entry.Access.WRITE)) {
            e2.setTime(Entry.Access.WRITE, System.currentTimeMillis());
        }
    }

    boolean setTime(FsEntryName fsEntryName, BitField<Entry.Access> bitField, long l2) throws IOException {
        if (0L > l2) {
            throw new IllegalArgumentException(fsEntryName.toString() + " (negative access time)");
        }
        FsCovariantEntry<E> fsCovariantEntry = this.master.get(fsEntryName.getPath());
        if (null == fsCovariantEntry) {
            throw new FsArchiveFileSystemException(fsEntryName, "archive entry not found");
        }
        this.touch();
        E e2 = fsCovariantEntry.getEntry();
        boolean bl2 = true;
        for (Entry.Access access : bitField) {
            bl2 &= e2.setTime(access, l2);
        }
        return bl2;
    }

    boolean setTime(FsEntryName fsEntryName, Map<Entry.Access, Long> map) throws IOException {
        FsCovariantEntry<E> fsCovariantEntry = this.master.get(fsEntryName.getPath());
        if (null == fsCovariantEntry) {
            throw new FsArchiveFileSystemException(fsEntryName, "archive entry not found");
        }
        this.touch();
        E e2 = fsCovariantEntry.getEntry();
        boolean bl2 = true;
        for (Map.Entry<Entry.Access, Long> entry : map.entrySet()) {
            long l2 = entry.getValue();
            bl2 &= 0L <= l2 && e2.setTime(entry.getKey(), l2);
        }
        return bl2;
    }

    boolean isWritable(FsEntryName fsEntryName) {
        return !this.isReadOnly();
    }

    void setReadOnly(FsEntryName fsEntryName) throws FsArchiveFileSystemException {
        if (!this.isReadOnly()) {
            throw new FsArchiveFileSystemException(fsEntryName, "cannot set read-only state");
        }
    }

    static interface TouchListener {
        public void preTouch() throws IOException;
    }

    private static final class Splitter
    extends Paths.Splitter {
        Splitter() {
            super('/', false);
        }

        @Override
        public String getParentPath() {
            String string = super.getParentPath();
            return null != string ? string : ROOT_PATH;
        }
    }

    private static final class EntryTable<E extends FsArchiveEntry> {
        final Map<String, FsCovariantEntry<E>> map;

        EntryTable(int n2) {
            this.map = new LinkedHashMap<String, FsCovariantEntry<E>>(n2);
        }

        int getSize() {
            return this.map.size();
        }

        Iterator<FsCovariantEntry<E>> iterator() {
            return Collections.unmodifiableCollection(this.map.values()).iterator();
        }

        FsCovariantEntry<E> add(String string, E e2) {
            FsCovariantEntry<E> fsCovariantEntry = this.map.get(string);
            if (null == fsCovariantEntry) {
                fsCovariantEntry = new FsCovariantEntry(string);
                this.map.put(string, fsCovariantEntry);
            }
            fsCovariantEntry.put(e2.getType(), e2);
            return fsCovariantEntry;
        }

        @Nullable
        FsCovariantEntry<E> get(String string) {
            return this.map.get(string);
        }

        @Nullable
        FsCovariantEntry<E> remove(String string) {
            return this.map.remove(string);
        }
    }

    private static final class SegmentLink<E extends FsArchiveEntry>
    implements Link<FsCovariantEntry<E>> {
        @Nullable
        final String base;
        final FsCovariantEntry<E> entry;

        SegmentLink(@CheckForNull String string, FsCovariantEntry<E> fsCovariantEntry) {
            this.entry = fsCovariantEntry;
            this.base = string;
        }

        @Override
        public FsCovariantEntry<E> getTarget() {
            return this.entry;
        }
    }

    private final class PathLink
    implements FsArchiveFileSystemOperation<E> {
        final boolean createParents;
        final BitField<FsOutputOption> options;
        final SegmentLink<E>[] links;
        long time = -1L;

        PathLink(String string, Entry.Type type, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) throws FsArchiveFileSystemException {
            this.createParents = bitField.get(FsOutputOption.CREATE_PARENTS);
            this.options = bitField.clear(FsOutputOption.CREATE_PARENTS);
            this.links = this.newSegmentLinks(1, string, type, entry);
        }

        private SegmentLink<E>[] newSegmentLinks(int n2, String string, Entry.Type type, @CheckForNull Entry entry) throws FsArchiveFileSystemException {
            SegmentLink[] segmentLinkArray;
            FsArchiveFileSystem.this.splitter.split(string);
            String string2 = FsArchiveFileSystem.this.splitter.getParentPath();
            String string3 = FsArchiveFileSystem.this.splitter.getMemberName();
            FsCovariantEntry fsCovariantEntry = FsArchiveFileSystem.this.master.get(string2);
            if (null != fsCovariantEntry) {
                if (!fsCovariantEntry.isType(Entry.Type.DIRECTORY)) {
                    throw new FsArchiveFileSystemException(string, "parent entry must be a directory");
                }
                segmentLinkArray = new SegmentLink[n2 + 1];
                segmentLinkArray[0] = new SegmentLink(null, fsCovariantEntry);
                FsCovariantEntry<FsArchiveEntry> fsCovariantEntry2 = new FsCovariantEntry<FsArchiveEntry>(string);
                fsCovariantEntry2.put(type, FsArchiveFileSystem.this.newCheckedEntry(string, type, this.options, entry));
                segmentLinkArray[1] = new SegmentLink(string3, fsCovariantEntry2);
            } else if (this.createParents) {
                segmentLinkArray = this.newSegmentLinks(n2 + 1, string2, Entry.Type.DIRECTORY, null);
                FsCovariantEntry<FsArchiveEntry> fsCovariantEntry3 = new FsCovariantEntry<FsArchiveEntry>(string);
                fsCovariantEntry3.put(type, FsArchiveFileSystem.this.newCheckedEntry(string, type, this.options, entry));
                segmentLinkArray[segmentLinkArray.length - n2] = new SegmentLink(string3, fsCovariantEntry3);
            } else {
                throw new FsArchiveFileSystemException(string, "missing parent directory entry");
            }
            return segmentLinkArray;
        }

        @Override
        public void commit() throws IOException {
            assert (2 <= this.links.length);
            FsArchiveFileSystem.this.touch();
            int n2 = this.links.length;
            FsCovariantEntry fsCovariantEntry = this.links[0].entry;
            Object e2 = fsCovariantEntry.get(Entry.Type.DIRECTORY);
            for (int i2 = 1; i2 < n2; ++i2) {
                SegmentLink segmentLink = this.links[i2];
                FsCovariantEntry fsCovariantEntry2 = segmentLink.entry;
                Object e3 = fsCovariantEntry2.getEntry();
                String string = segmentLink.base;
                FsArchiveFileSystem.this.master.add(fsCovariantEntry2.getName(), e3);
                if (FsArchiveFileSystem.this.master.get(fsCovariantEntry.getName()).add(string) && -1L != e2.getTime(Entry.Access.WRITE)) {
                    e2.setTime(Entry.Access.WRITE, this.getCurrentTimeMillis());
                }
                fsCovariantEntry = fsCovariantEntry2;
                e2 = e3;
            }
            if (-1L == e2.getTime(Entry.Access.WRITE)) {
                e2.setTime(Entry.Access.WRITE, this.getCurrentTimeMillis());
            }
        }

        private long getCurrentTimeMillis() {
            return -1L != this.time ? this.time : (this.time = System.currentTimeMillis());
        }

        @Override
        public FsCovariantEntry<E> getTarget() {
            return this.links[this.links.length - 1].getTarget();
        }
    }
}

