/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsLockModel;
import de.schlichtherle.truezip.fs.FsLockModelDecoratingController;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsNeedsSyncException;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsResourceOpenException;
import de.schlichtherle.truezip.fs.FsSyncController;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncExceptionBuilder;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.FsSyncOptions;
import de.schlichtherle.truezip.fs.FsSyncWarningException;
import de.schlichtherle.truezip.io.DecoratingInputStream;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.io.DecoratingSeekableByteChannel;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.ClutchInputSocket;
import de.schlichtherle.truezip.socket.ClutchOutputSocket;
import de.schlichtherle.truezip.socket.DelegatingInputSocket;
import de.schlichtherle.truezip.socket.DelegatingOutputSocket;
import de.schlichtherle.truezip.socket.IOCache;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.JSE7;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
final class FsCacheController
extends FsLockModelDecoratingController<FsController<? extends FsLockModel>> {
    private static final Logger logger = Logger.getLogger(FsCacheController.class.getName(), FsCacheController.class.getName());
    private static final SocketFactory SOCKET_FACTORY = JSE7.AVAILABLE ? SocketFactory.NIO2 : SocketFactory.OIO;
    private final IOPool<?> pool;
    private final Map<FsEntryName, EntryCache> caches = new HashMap<FsEntryName, EntryCache>();

    FsCacheController(IOPool<?> iOPool, FsController<? extends FsLockModel> fsController) {
        super(fsController);
        this.pool = iOPool;
        if (null == this.pool) {
            throw new NullPointerException();
        }
    }

    @Override
    public InputSocket<?> getInputSocket(final FsEntryName fsEntryName, final BitField<FsInputOption> bitField) {
        class Input
        extends DelegatingInputSocket<Entry> {
            Input() {
            }

            @Override
            protected InputSocket<?> getDelegate() {
                assert (FsCacheController.this.isWriteLockedByCurrentThread());
                EntryCache entryCache = (EntryCache)FsCacheController.this.caches.get(fsEntryName);
                if (null == entryCache) {
                    if (!bitField.get(FsInputOption.CACHE)) {
                        return FsCacheController.this.delegate.getInputSocket(fsEntryName, bitField);
                    }
                    entryCache = new EntryCache(fsEntryName);
                }
                return entryCache.getInputSocket(bitField);
            }
        }
        return new Input();
    }

    @Override
    @SuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
    public OutputSocket<?> getOutputSocket(final FsEntryName fsEntryName, final BitField<FsOutputOption> bitField, final @CheckForNull Entry entry) {
        class Output
        extends DelegatingOutputSocket<Entry> {
            Output() {
            }

            @Override
            protected OutputSocket<?> getDelegate() {
                assert (FsCacheController.this.isWriteLockedByCurrentThread());
                EntryCache entryCache = (EntryCache)FsCacheController.this.caches.get(fsEntryName);
                if (null == entryCache) {
                    if (!bitField.get(FsOutputOption.CACHE)) {
                        return FsCacheController.this.delegate.getOutputSocket(fsEntryName, bitField, entry);
                    }
                    entryCache = new EntryCache(fsEntryName);
                }
                return entryCache.getOutputSocket(bitField, entry);
            }
        }
        return new Output();
    }

    @Override
    public void mknod(FsEntryName fsEntryName, Entry.Type type, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) throws IOException {
        assert (this.isWriteLockedByCurrentThread());
        this.delegate.mknod(fsEntryName, type, bitField, entry);
        EntryCache entryCache = this.caches.remove(fsEntryName);
        if (null != entryCache) {
            entryCache.clear();
        }
    }

    @Override
    public void unlink(FsEntryName fsEntryName, BitField<FsOutputOption> bitField) throws IOException {
        assert (this.isWriteLockedByCurrentThread());
        this.delegate.unlink(fsEntryName, bitField);
        EntryCache entryCache = this.caches.remove(fsEntryName);
        if (null != entryCache) {
            entryCache.clear();
        }
    }

    @Override
    public void sync(BitField<FsSyncOption> bitField) throws FsSyncException {
        this.syncCacheEntries(bitField);
        this.delegate.sync(bitField.clear(FsSyncOption.CLEAR_CACHE));
        if (this.caches.isEmpty()) {
            this.setMounted(false);
        }
    }

    private void syncCacheEntries(BitField<FsSyncOption> bitField) throws FsSyncWarningException, FsSyncException {
        boolean bl2;
        assert (this.isWriteLockedByCurrentThread());
        if (0 >= this.caches.size()) {
            return;
        }
        boolean bl3 = !bitField.get(FsSyncOption.ABORT_CHANGES);
        boolean bl4 = bl2 = !bl3 || bitField.get(FsSyncOption.CLEAR_CACHE);
        assert (bl3 || bl2);
        FsSyncExceptionBuilder fsSyncExceptionBuilder = new FsSyncExceptionBuilder();
        Iterator<EntryCache> iterator = this.caches.values().iterator();
        while (iterator.hasNext()) {
            EntryCache entryCache = iterator.next();
            if (bl3) {
                try {
                    entryCache.flush();
                }
                catch (IOException iOException) {
                    throw (FsSyncException)fsSyncExceptionBuilder.fail(new FsSyncException((FsModel)this.getModel(), iOException));
                }
            }
            if (!bl2) continue;
            iterator.remove();
            try {
                entryCache.clear();
            }
            catch (IOException iOException) {
                fsSyncExceptionBuilder.warn(new FsSyncWarningException((FsModel)this.getModel(), iOException));
            }
        }
        fsSyncExceptionBuilder.check();
    }

    static /* synthetic */ Logger access$700() {
        return logger;
    }

    @Immutable
    private final class EntryCache {
        final FsEntryName name;
        final IOCache cache;

        EntryCache(FsEntryName fsEntryName) {
            this.name = fsEntryName;
            this.cache = IOCache.Strategy.WRITE_BACK.newCache(FsCacheController.this.pool);
        }

        InputSocket<?> getInputSocket(BitField<FsInputOption> bitField) {
            return this.cache.configure(new Input(bitField)).getInputSocket();
        }

        OutputSocket<?> getOutputSocket(BitField<FsOutputOption> bitField, @CheckForNull Entry entry) {
            return SOCKET_FACTORY.newOutputSocket(this, bitField, entry);
        }

        void flush() throws IOException {
            this.cache.flush();
        }

        void clear() throws IOException {
            this.cache.clear();
        }

        void register() {
            assert (FsCacheController.this.isWriteLockedByCurrentThread());
            FsCacheController.this.caches.put(this.name, this);
        }

        @Immutable
        class Output
        extends ClutchOutputSocket<Entry> {
            final BitField<FsOutputOption> options;
            @CheckForNull
            final Entry template;

            Output(BitField<FsOutputOption> bitField, @CheckForNull Entry entry) {
                this.options = bitField.clear(FsOutputOption.CACHE);
                this.template = entry;
            }

            @Override
            protected OutputSocket<? extends Entry> getLazyDelegate() {
                return EntryCache.this.cache.configure(FsCacheController.this.delegate.getOutputSocket(EntryCache.this.name, this.options.clear(FsOutputOption.EXCLUSIVE), this.template)).getOutputSocket();
            }

            @Override
            public Entry getLocalTarget() throws IOException {
                return (Entry)this.getBoundSocket().getLocalTarget();
            }

            @Override
            public final OutputStream newOutputStream() throws IOException {
                this.preOutput();
                return new Stream();
            }

            void preOutput() throws IOException {
                this.mknod(this.options, this.template);
            }

            void postOutput() throws IOException {
                this.mknod(this.options.clear(FsOutputOption.EXCLUSIVE), null != this.template ? this.template : EntryCache.this.cache.getEntry());
                EntryCache.this.register();
            }

            /*
             * Unable to fully structure code
             */
            void mknod(BitField<FsOutputOption> var1_1, @CheckForNull Entry var2_2) throws IOException {
                while (true) {
                    try {
                        FsCacheController.this.delegate.mknod(EntryCache.this.name, Entry.Type.FILE, var1_1, var2_2);
                    }
                    catch (FsNeedsSyncException var3_3) {
                        if (var1_1.get(FsOutputOption.EXCLUSIVE)) {
                            throw var3_3;
                        }
                        var4_4 = FsSyncController.modify(FsSyncOptions.SYNC);
                        if (FsSyncOptions.SYNC == var4_4) {
                            throw var3_3;
                        }
                        try {
                            FsCacheController.this.delegate.sync(var4_4);
                            continue;
                        }
                        catch (FsSyncException var5_5) {
                            if (JSE7.AVAILABLE) {
                                var5_5.addSuppressed(var3_3);
                            }
                            if (!(var5_5.getCause() instanceof FsResourceOpenException)) {
                                throw var5_5;
                            }
                            var6_6 = var1_1;
                            if ((var1_1 = var6_6.set(FsOutputOption.GROW)) == var6_6) ** break;
                            continue;
                            FsCacheController.access$700().log(Level.FINE, "ignoring", var5_5);
                        }
                    }
                    break;
                }
            }

            final class Stream
            extends DecoratingOutputStream {
                @CreatesObligation
                @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
                Stream() throws IOException {
                    super(Output.this.getBoundSocket().newOutputStream());
                    EntryCache.this.register();
                }

                @Override
                public void close() throws IOException {
                    this.delegate.close();
                    Output.this.postOutput();
                }
            }
        }

        @Immutable
        final class Nio2Output
        extends Output {
            Nio2Output(BitField<FsOutputOption> bitField, @CheckForNull Entry entry) {
                super(bitField, entry);
            }

            @Override
            public SeekableByteChannel newSeekableByteChannel() throws IOException {
                this.preOutput();
                return new Channel();
            }

            final class Channel
            extends DecoratingSeekableByteChannel {
                @CreatesObligation
                @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
                Channel() throws IOException {
                    super(Nio2Output.this.getBoundSocket().newSeekableByteChannel());
                    EntryCache.this.register();
                }

                @Override
                public void close() throws IOException {
                    this.delegate.close();
                    Nio2Output.this.postOutput();
                }
            }
        }

        @Immutable
        final class Input
        extends ClutchInputSocket<Entry> {
            final BitField<FsInputOption> options;

            Input(BitField<FsInputOption> bitField) {
                this.options = bitField.clear(FsInputOption.CACHE);
            }

            @Override
            protected InputSocket<? extends Entry> getLazyDelegate() {
                return FsCacheController.this.delegate.getInputSocket(EntryCache.this.name, this.options);
            }

            @Override
            public Entry getLocalTarget() throws IOException {
                return (Entry)this.getBoundSocket().getLocalTarget();
            }

            @Override
            public SeekableByteChannel newSeekableByteChannel() {
                throw new UnsupportedOperationException();
            }

            @Override
            public ReadOnlyFile newReadOnlyFile() {
                throw new UnsupportedOperationException();
            }

            @Override
            public InputStream newInputStream() throws IOException {
                return new Stream();
            }

            final class Stream
            extends DecoratingInputStream {
                @CreatesObligation
                @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
                Stream() throws IOException {
                    super(Input.this.getBoundSocket().newInputStream());
                    assert (FsCacheController.this.isMounted());
                }

                @Override
                public void close() throws IOException {
                    this.delegate.close();
                    EntryCache.this.register();
                }
            }
        }
    }

    @Immutable
    private static enum SocketFactory {
        NIO2{

            @Override
            OutputSocket<?> newOutputSocket(EntryCache entryCache, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) {
                EntryCache entryCache2 = entryCache;
                entryCache2.getClass();
                return entryCache2.new EntryCache.Nio2Output(bitField, entry);
            }
        }
        ,
        OIO{

            @Override
            OutputSocket<?> newOutputSocket(EntryCache entryCache, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) {
                EntryCache entryCache2 = entryCache;
                entryCache2.getClass();
                return entryCache2.new EntryCache.Output(bitField, entry);
            }
        };


        abstract OutputSocket<?> newOutputSocket(EntryCache var1, BitField<FsOutputOption> var2, @CheckForNull Entry var3);
    }
}

