/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsArchiveDriver;
import de.schlichtherle.truezip.fs.FsArchiveEntry;
import de.schlichtherle.truezip.io.Paths;
import java.io.CharConversionException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class FsCharsetArchiveDriver<E extends FsArchiveEntry>
extends FsArchiveDriver<E> {
    private final Charset charset;
    private final ThreadLocal<CharsetEncoder> encoder = new ThreadLocal();

    protected FsCharsetArchiveDriver(Charset charset) {
        this.charset = charset;
        if (null == this.charset) {
            throw new NullPointerException();
        }
    }

    public Charset getCharset() {
        return this.charset;
    }

    public static String toZipOrTarEntryName(String string, Entry.Type type) {
        return Entry.Type.DIRECTORY == type ? (string.endsWith("/") ? string : string + '/') : Paths.cutTrailingSeparators(string, '/');
    }

    @Override
    protected final void assertEncodable(String string) throws CharConversionException {
        CharsetEncoder charsetEncoder = this.encoder.get();
        if (null == charsetEncoder) {
            charsetEncoder = this.getCharset().newEncoder();
            this.encoder.set(charsetEncoder);
        }
        if (!charsetEncoder.canEncode(string)) {
            throw new CharConversionException(string + " (entry name not encodable with " + this.getCharset() + ")");
        }
    }

    @Override
    public String toString() {
        return String.format("%s[charset=%s, federated=%b, priority=%d]", this.getClass().getName(), this.getCharset(), this.isFederated(), this.getPriority());
    }
}

