/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.entry.EntryName;
import de.schlichtherle.truezip.fs.FsUriModifier;
import de.schlichtherle.truezip.util.QuotedUriSyntaxException;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class FsEntryName
extends EntryName {
    private static final long serialVersionUID = 2212342253466752478L;
    private static final String ILLEGAL_PREFIX = "../";
    public static final FsEntryName ROOT;

    @Deprecated
    public static FsEntryName create(String string) {
        return FsEntryName.create(string, FsUriModifier.NULL);
    }

    @Deprecated
    public static FsEntryName create(String string, FsUriModifier fsUriModifier) {
        try {
            return string.isEmpty() ? ROOT : new FsEntryName(string, fsUriModifier);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
    }

    public static FsEntryName create(URI uRI) {
        return FsEntryName.create(uRI, FsUriModifier.NULL);
    }

    public static FsEntryName create(URI uRI, FsUriModifier fsUriModifier) {
        try {
            return uRI.toString().isEmpty() ? ROOT : new FsEntryName(uRI, fsUriModifier);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
    }

    @Deprecated
    public FsEntryName(String string) throws URISyntaxException {
        this(string, FsUriModifier.NULL);
    }

    @Deprecated
    public FsEntryName(String string, FsUriModifier fsUriModifier) throws URISyntaxException {
        this(new URI(string), fsUriModifier);
    }

    public FsEntryName(URI uRI) throws URISyntaxException {
        this(uRI, FsUriModifier.NULL);
    }

    public FsEntryName(URI uRI, FsUriModifier fsUriModifier) throws URISyntaxException {
        uRI = fsUriModifier.modify(uRI, FsUriModifier.PostFix.ENTRY_NAME);
        super(uRI);
        this.parse(uRI);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this.parse(this.toUri());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw (InvalidObjectException)new InvalidObjectException(uRISyntaxException.toString()).initCause(uRISyntaxException);
        }
    }

    private void parse(URI uRI) throws URISyntaxException {
        String string = uRI.getRawPath();
        if (string.startsWith("/")) {
            throw new QuotedUriSyntaxException(uRI, "Illegal start of URI path component");
        }
        if (!string.isEmpty() && ILLEGAL_PREFIX.startsWith(string.substring(0, Math.min(string.length(), ILLEGAL_PREFIX.length())))) {
            throw new QuotedUriSyntaxException(uRI, "Illegal start of URI path component");
        }
        if (string.endsWith("/")) {
            throw new QuotedUriSyntaxException(uRI, "Illegal separator \"/\" at end of URI path");
        }
        assert (this.invariants());
    }

    public FsEntryName(FsEntryName fsEntryName, FsEntryName fsEntryName2) {
        super(fsEntryName, fsEntryName2);
        assert (this.invariants());
    }

    private boolean invariants() {
        assert (null != this.toUri());
        assert (this.toUri().normalize() == this.toUri());
        String string = this.toUri().getRawPath();
        assert (!"..".equals(string));
        assert (!string.startsWith("/"));
        assert (!string.startsWith("./"));
        assert (!string.startsWith(ILLEGAL_PREFIX));
        assert (!string.endsWith("/"));
        return true;
    }

    public boolean isRoot() {
        URI uRI = this.toUri();
        String string = uRI.getRawPath();
        if (null != string && !string.isEmpty()) {
            return false;
        }
        String string2 = uRI.getRawQuery();
        return null == string2;
    }

    static {
        try {
            ROOT = new FsEntryName(new URI(""));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new AssertionError((Object)uRISyntaxException);
        }
    }
}

