/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsPath;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class FsEntryNotFoundException
extends FileNotFoundException {
    private static final long serialVersionUID = 2972350932856838564L;
    private final FsPath path;

    public FsEntryNotFoundException(FsModel fsModel, FsEntryName fsEntryName, @CheckForNull String string) {
        super(string);
        this.path = fsModel.getMountPoint().resolve(fsEntryName);
    }

    public FsEntryNotFoundException(FsModel fsModel, FsEntryName fsEntryName, @CheckForNull IOException iOException) {
        super(null != iOException ? iOException.toString() : null);
        super.initCause(iOException);
        this.path = fsModel.getMountPoint().resolve(fsEntryName);
    }

    @Override
    @Nullable
    public String getMessage() {
        String string = super.getMessage();
        return null != string ? this.path.toString() + " (" + string + ")" : this.path.toString();
    }
}

