/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDecoratingController;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsFalsePositiveArchiveException;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsNeedsLockRetryException;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsPath;
import de.schlichtherle.truezip.fs.FsPersistentFalsePositiveArchiveException;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.ControlFlowException;
import de.schlichtherle.truezip.util.JSE7;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class FsFalsePositiveArchiveController
extends FsDecoratingController<FsModel, FsController<?>> {
    private volatile State state = new TryChild();
    @CheckForNull
    private FsController<?> parent;
    @CheckForNull
    private FsPath path;

    FsFalsePositiveArchiveController(FsController<?> fsController) {
        super(fsController);
        assert (null != super.getParent());
    }

    @Nullable
    <T> T call(Operation<T> operation, FsEntryName fsEntryName) throws IOException {
        State state = this.state;
        try {
            return state.call(operation, fsEntryName);
        }
        catch (FsPersistentFalsePositiveArchiveException fsPersistentFalsePositiveArchiveException) {
            assert (state instanceof TryChild);
            this.state = new UseParent(fsPersistentFalsePositiveArchiveException);
            return this.state.call(operation, fsEntryName);
        }
        catch (FsFalsePositiveArchiveException fsFalsePositiveArchiveException) {
            assert (state instanceof TryChild);
            return new UseParent(fsFalsePositiveArchiveException).call(operation, fsEntryName);
        }
    }

    @Override
    public FsController<?> getParent() {
        FsController<?> fsController = this.parent;
        return null != fsController ? fsController : (this.parent = this.delegate.getParent());
    }

    FsEntryName parent(FsEntryName fsEntryName) {
        return this.getPath().resolve(fsEntryName).getEntryName();
    }

    private FsPath getPath() {
        FsPath fsPath = this.path;
        return null != fsPath ? fsPath : (this.path = this.getMountPoint().getPath());
    }

    @Override
    public boolean isReadOnly() throws IOException {
        return this.call(new IsReadOnly(), FsEntryName.ROOT);
    }

    @Override
    public FsEntry getEntry(FsEntryName fsEntryName) throws IOException {
        return this.call(new GetEntry(), fsEntryName);
    }

    @Override
    public boolean isReadable(FsEntryName fsEntryName) throws IOException {
        return this.call(new IsReadable(), fsEntryName);
    }

    @Override
    public boolean isWritable(FsEntryName fsEntryName) throws IOException {
        return this.call(new IsWritable(), fsEntryName);
    }

    @Override
    public boolean isExecutable(FsEntryName fsEntryName) throws IOException {
        return this.call(new IsExecutable(), fsEntryName);
    }

    @Override
    public void setReadOnly(FsEntryName fsEntryName) throws IOException {
        this.call(new SetReadOnly(), fsEntryName);
    }

    @Override
    public boolean setTime(FsEntryName fsEntryName, final Map<Entry.Access, Long> map, final BitField<FsOutputOption> bitField) throws IOException {
        final class SetTime
        implements Operation<Boolean> {
            SetTime() {
            }

            @Override
            public Boolean call(FsController<?> fsController, FsEntryName fsEntryName) throws IOException {
                return fsController.setTime(fsEntryName, map, bitField);
            }
        }
        return this.call(new SetTime(), fsEntryName);
    }

    @Override
    public boolean setTime(FsEntryName fsEntryName, final BitField<Entry.Access> bitField, final long l2, final BitField<FsOutputOption> bitField2) throws IOException {
        final class SetTime
        implements Operation<Boolean> {
            SetTime() {
            }

            @Override
            public Boolean call(FsController<?> fsController, FsEntryName fsEntryName) throws IOException {
                return fsController.setTime(fsEntryName, bitField, l2, bitField2);
            }
        }
        return this.call(new SetTime(), fsEntryName);
    }

    @Override
    public InputSocket<?> getInputSocket(final FsEntryName fsEntryName, final BitField<FsInputOption> bitField) {
        @NotThreadSafe
        final class Input
        extends InputSocket<Entry> {
            @CheckForNull
            FsController<?> lastController;
            @Nullable
            InputSocket<? extends Entry> delegate;

            Input() {
            }

            InputSocket<?> getBoundDelegate(FsController<?> fsController, FsEntryName fsEntryName2) {
                InputSocket<Entry> inputSocket;
                if (this.lastController == fsController) {
                    inputSocket = this.delegate;
                } else {
                    this.lastController = fsController;
                    inputSocket = this.delegate = this.lastController.getInputSocket(fsEntryName2, bitField);
                }
                return inputSocket.bind(this);
            }

            @Override
            public Entry getLocalTarget() throws IOException {
                return FsFalsePositiveArchiveController.this.call(new 1Input.GetLocalTarget(), fsEntryName);
            }

            @Override
            public ReadOnlyFile newReadOnlyFile() throws IOException {
                return FsFalsePositiveArchiveController.this.call(new 1Input.NewReadOnlyFile(), fsEntryName);
            }

            @Override
            public SeekableByteChannel newSeekableByteChannel() throws IOException {
                return FsFalsePositiveArchiveController.this.call(new 1Input.NewSeekableByteChannel(), fsEntryName);
            }

            @Override
            public InputStream newInputStream() throws IOException {
                return FsFalsePositiveArchiveController.this.call(new 1Input.NewInputStream(), fsEntryName);
            }

            final class 1Input.NewInputStream
            implements Operation<InputStream> {
                1Input.NewInputStream() {
                }

                @Override
                public InputStream call(FsController<?> fsController, FsEntryName fsEntryName) throws IOException {
                    return this.getBoundDelegate(fsController, fsEntryName).newInputStream();
                }
            }

            final class 1Input.NewSeekableByteChannel
            implements Operation<SeekableByteChannel> {
                1Input.NewSeekableByteChannel() {
                }

                @Override
                public SeekableByteChannel call(FsController<?> fsController, FsEntryName fsEntryName) throws IOException {
                    return this.getBoundDelegate(fsController, fsEntryName).newSeekableByteChannel();
                }
            }

            final class 1Input.NewReadOnlyFile
            implements Operation<ReadOnlyFile> {
                1Input.NewReadOnlyFile() {
                }

                @Override
                public ReadOnlyFile call(FsController<?> fsController, FsEntryName fsEntryName) throws IOException {
                    return this.getBoundDelegate(fsController, fsEntryName).newReadOnlyFile();
                }
            }

            final class 1Input.GetLocalTarget
            implements Operation<Entry> {
                1Input.GetLocalTarget() {
                }

                @Override
                public Entry call(FsController<?> fsController, FsEntryName fsEntryName) throws IOException {
                    return (Entry)this.getBoundDelegate(fsController, fsEntryName).getLocalTarget();
                }
            }
        }
        return new Input();
    }

    @Override
    @SuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
    public OutputSocket<?> getOutputSocket(final FsEntryName fsEntryName, final BitField<FsOutputOption> bitField, final @CheckForNull Entry entry) {
        @NotThreadSafe
        final class Output
        extends OutputSocket<Entry> {
            @CheckForNull
            FsController<?> lastController;
            @Nullable
            OutputSocket<? extends Entry> delegate;

            Output() {
            }

            OutputSocket<?> getBoundDelegate(FsController<?> fsController, FsEntryName fsEntryName2) {
                OutputSocket<Entry> outputSocket;
                if (this.lastController == fsController) {
                    outputSocket = this.delegate;
                } else {
                    this.lastController = fsController;
                    outputSocket = this.delegate = this.lastController.getOutputSocket(fsEntryName2, bitField, entry);
                }
                return outputSocket.bind(this);
            }

            @Override
            public Entry getLocalTarget() throws IOException {
                return FsFalsePositiveArchiveController.this.call(new 1Output.GetLocalTarget(), fsEntryName);
            }

            @Override
            public SeekableByteChannel newSeekableByteChannel() throws IOException {
                return FsFalsePositiveArchiveController.this.call(new 1Output.NewSeekableByteChannel(), fsEntryName);
            }

            @Override
            public OutputStream newOutputStream() throws IOException {
                return FsFalsePositiveArchiveController.this.call(new 1Output.NewOutputStream(), fsEntryName);
            }

            final class 1Output.NewOutputStream
            implements Operation<OutputStream> {
                1Output.NewOutputStream() {
                }

                @Override
                public OutputStream call(FsController<?> fsController, FsEntryName fsEntryName) throws IOException {
                    return this.getBoundDelegate(fsController, fsEntryName).newOutputStream();
                }
            }

            final class 1Output.NewSeekableByteChannel
            implements Operation<SeekableByteChannel> {
                1Output.NewSeekableByteChannel() {
                }

                @Override
                public SeekableByteChannel call(FsController<?> fsController, FsEntryName fsEntryName) throws IOException {
                    return this.getBoundDelegate(fsController, fsEntryName).newSeekableByteChannel();
                }
            }

            final class 1Output.GetLocalTarget
            implements Operation<Entry> {
                1Output.GetLocalTarget() {
                }

                @Override
                public Entry call(FsController<?> fsController, FsEntryName fsEntryName) throws IOException {
                    return (Entry)this.getBoundDelegate(fsController, fsEntryName).getLocalTarget();
                }
            }
        }
        return new Output();
    }

    @Override
    @SuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
    public void mknod(FsEntryName fsEntryName, final Entry.Type type, final BitField<FsOutputOption> bitField, final @CheckForNull Entry entry) throws IOException {
        final class Mknod
        implements Operation<Void> {
            Mknod() {
            }

            @Override
            public Void call(FsController<?> fsController, FsEntryName fsEntryName) throws IOException {
                fsController.mknod(fsEntryName, type, bitField, entry);
                return null;
            }
        }
        this.call(new Mknod(), fsEntryName);
    }

    @Override
    public void unlink(FsEntryName fsEntryName, final BitField<FsOutputOption> bitField) throws IOException {
        final class Unlink
        implements Operation<Void> {
            Unlink() {
            }

            @Override
            public Void call(FsController<?> fsController, FsEntryName fsEntryName) throws IOException {
                fsController.unlink(fsEntryName, bitField);
                if (fsEntryName.isRoot()) {
                    assert (fsController == FsFalsePositiveArchiveController.this.delegate);
                    FsFalsePositiveArchiveController.this.getParent().unlink(FsFalsePositiveArchiveController.this.parent(fsEntryName), bitField);
                }
                return null;
            }
        }
        Unlink unlink = new Unlink();
        if (fsEntryName.isRoot()) {
            TryChild tryChild = new TryChild();
            try {
                tryChild.call(unlink, FsEntryName.ROOT);
            }
            catch (FsFalsePositiveArchiveException fsFalsePositiveArchiveException) {
                new UseParent(fsFalsePositiveArchiveException).call(unlink, FsEntryName.ROOT);
            }
            this.state = tryChild;
        } else {
            this.call(unlink, fsEntryName);
        }
    }

    @Override
    public void sync(BitField<FsSyncOption> bitField) throws FsSyncException {
        try {
            this.delegate.sync(bitField);
        }
        catch (FsSyncException fsSyncException) {
            assert (this.state instanceof TryChild);
            throw fsSyncException;
        }
        catch (ControlFlowException controlFlowException) {
            assert (this.state instanceof TryChild);
            throw controlFlowException;
        }
        this.state = new TryChild();
    }

    @Immutable
    private final class UseParent
    implements State {
        final IOException originalCause;

        UseParent(FsFalsePositiveArchiveException fsFalsePositiveArchiveException) {
            this.originalCause = fsFalsePositiveArchiveException.getCause();
        }

        public <V> V call(Operation<V> operation, FsEntryName fsEntryName) throws IOException {
            try {
                return operation.call(FsFalsePositiveArchiveController.this.getParent(), FsFalsePositiveArchiveController.this.parent(fsEntryName));
            }
            catch (FsFalsePositiveArchiveException fsFalsePositiveArchiveException) {
                throw new AssertionError((Object)fsFalsePositiveArchiveException);
            }
            catch (ControlFlowException controlFlowException) {
                assert (controlFlowException instanceof FsNeedsLockRetryException);
                throw controlFlowException;
            }
            catch (IOException iOException) {
                if (JSE7.AVAILABLE && this.originalCause != iOException) {
                    this.originalCause.addSuppressed(iOException);
                }
                throw this.originalCause;
            }
        }
    }

    @Immutable
    private final class TryChild
    implements State {
        private TryChild() {
        }

        public <V> V call(Operation<V> operation, FsEntryName fsEntryName) throws IOException {
            return operation.call(FsFalsePositiveArchiveController.this.delegate, fsEntryName);
        }
    }

    private static interface State {
        @Nullable
        public <T> T call(Operation<T> var1, FsEntryName var2) throws IOException;
    }

    private static interface Operation<V> {
        @Nullable
        public V call(FsController<?> var1, FsEntryName var2) throws IOException;
    }

    private static final class SetReadOnly
    implements Operation<Void> {
        private SetReadOnly() {
        }

        @Override
        public Void call(FsController<?> fsController, FsEntryName fsEntryName) throws IOException {
            fsController.setReadOnly(fsEntryName);
            return null;
        }
    }

    private static final class IsExecutable
    implements Operation<Boolean> {
        private IsExecutable() {
        }

        @Override
        public Boolean call(FsController<?> fsController, FsEntryName fsEntryName) throws IOException {
            return fsController.isExecutable(fsEntryName);
        }
    }

    private static final class IsWritable
    implements Operation<Boolean> {
        private IsWritable() {
        }

        @Override
        public Boolean call(FsController<?> fsController, FsEntryName fsEntryName) throws IOException {
            return fsController.isWritable(fsEntryName);
        }
    }

    private static final class IsReadable
    implements Operation<Boolean> {
        private IsReadable() {
        }

        @Override
        public Boolean call(FsController<?> fsController, FsEntryName fsEntryName) throws IOException {
            return fsController.isReadable(fsEntryName);
        }
    }

    private static final class GetEntry
    implements Operation<FsEntry> {
        private GetEntry() {
        }

        @Override
        public FsEntry call(FsController<?> fsController, FsEntryName fsEntryName) throws IOException {
            return fsController.getEntry(fsEntryName);
        }
    }

    private static final class IsReadOnly
    implements Operation<Boolean> {
        private IsReadOnly() {
        }

        @Override
        public Boolean call(FsController<?> fsController, FsEntryName fsEntryName) throws IOException {
            return fsController.isReadOnly();
        }
    }
}

