/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDecoratingController;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.io.DecoratingInputStream;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.io.DecoratingSeekableByteChannel;
import de.schlichtherle.truezip.rof.DecoratingReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.DecoratingInputSocket;
import de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.ControlFlowException;
import de.schlichtherle.truezip.util.JSE7;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class FsFinalizeController<M extends FsModel>
extends FsDecoratingController<M, FsController<? extends M>> {
    private static final Logger logger = Logger.getLogger(FsFinalizeController.class.getName(), FsFinalizeController.class.getName());
    private static final SocketFactory SOCKET_FACTORY = JSE7.AVAILABLE ? SocketFactory.NIO2 : SocketFactory.OIO;
    private static final IOException OK = new IOException((Throwable)null);

    FsFinalizeController(FsController<? extends M> fsController) {
        super(fsController);
    }

    @Override
    public InputSocket<?> getInputSocket(FsEntryName fsEntryName, BitField<FsInputOption> bitField) {
        return SOCKET_FACTORY.newInputSocket(this, fsEntryName, bitField);
    }

    @Override
    public OutputSocket<?> getOutputSocket(FsEntryName fsEntryName, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) {
        return SOCKET_FACTORY.newOutputSocket(this, fsEntryName, bitField, entry);
    }

    static void finalize(Closeable closeable, @CheckForNull IOException iOException) {
        if (OK == iOException) {
            logger.log(Level.FINEST, "closeCleared");
        } else if (null != iOException) {
            logger.log(Level.FINEST, "closeFailed", iOException);
        } else {
            try {
                closeable.close();
                logger.log(Level.INFO, "finalizeCleared");
            }
            catch (ControlFlowException controlFlowException) {
                logger.log(Level.SEVERE, "finalizeFailed", (Throwable)((Object)new AssertionError("Unexpected control flow exception!", controlFlowException)));
            }
            catch (Throwable throwable) {
                logger.log(Level.WARNING, "finalizeFailed", throwable);
            }
        }
    }

    private static final class FinalizeOutputStream
    extends DecoratingOutputStream {
        volatile IOException close;

        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        FinalizeOutputStream(@WillCloseWhenClosed OutputStream outputStream) {
            super(outputStream);
        }

        @Override
        public void close() throws IOException {
            try {
                this.delegate.close();
                this.close = OK;
            }
            catch (IOException iOException) {
                this.close = iOException;
                throw this.close;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                FsFinalizeController.finalize(this.delegate, this.close);
            }
            finally {
                super.finalize();
            }
        }
    }

    private static final class FinalizeInputStream
    extends DecoratingInputStream {
        volatile IOException close;

        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        FinalizeInputStream(@WillCloseWhenClosed InputStream inputStream) {
            super(inputStream);
        }

        @Override
        public void close() throws IOException {
            try {
                this.delegate.close();
                this.close = OK;
            }
            catch (IOException iOException) {
                this.close = iOException;
                throw this.close;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                FsFinalizeController.finalize(this.delegate, this.close);
            }
            finally {
                super.finalize();
            }
        }
    }

    private static final class FinalizeSeekableByteChannel
    extends DecoratingSeekableByteChannel {
        volatile IOException close;

        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        FinalizeSeekableByteChannel(@WillCloseWhenClosed SeekableByteChannel seekableByteChannel) {
            super(seekableByteChannel);
        }

        @Override
        public void close() throws IOException {
            try {
                this.delegate.close();
                this.close = OK;
            }
            catch (IOException iOException) {
                this.close = iOException;
                throw this.close;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                FsFinalizeController.finalize(this.delegate, this.close);
            }
            finally {
                super.finalize();
            }
        }
    }

    private static final class FinalizeReadOnlyFile
    extends DecoratingReadOnlyFile {
        volatile IOException close;

        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        FinalizeReadOnlyFile(@WillCloseWhenClosed ReadOnlyFile readOnlyFile) {
            super(readOnlyFile);
        }

        @Override
        public void close() throws IOException {
            try {
                this.delegate.close();
                this.close = OK;
            }
            catch (IOException iOException) {
                this.close = iOException;
                throw this.close;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                FsFinalizeController.finalize(this.delegate, this.close);
            }
            finally {
                super.finalize();
            }
        }
    }

    @Immutable
    private class Output
    extends DecoratingOutputSocket<Entry> {
        Output(FsEntryName fsEntryName, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) {
            super(FsFinalizeController.this.delegate.getOutputSocket(fsEntryName, bitField, entry));
        }

        @Override
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        public OutputStream newOutputStream() throws IOException {
            return new FinalizeOutputStream(this.getBoundSocket().newOutputStream());
        }
    }

    @Immutable
    private final class Nio2Output
    extends Output {
        Nio2Output(FsEntryName fsEntryName, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) {
            super(fsEntryName, bitField, entry);
        }

        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            return new FinalizeSeekableByteChannel(this.getBoundSocket().newSeekableByteChannel());
        }
    }

    @Immutable
    private class Input
    extends DecoratingInputSocket<Entry> {
        Input(FsEntryName fsEntryName, BitField<FsInputOption> bitField) {
            super(FsFinalizeController.this.delegate.getInputSocket(fsEntryName, bitField));
        }

        @Override
        public ReadOnlyFile newReadOnlyFile() throws IOException {
            return new FinalizeReadOnlyFile(this.getBoundSocket().newReadOnlyFile());
        }

        @Override
        public InputStream newInputStream() throws IOException {
            return new FinalizeInputStream(this.getBoundSocket().newInputStream());
        }
    }

    @Immutable
    private final class Nio2Input
    extends Input {
        Nio2Input(FsEntryName fsEntryName, BitField<FsInputOption> bitField) {
            super(fsEntryName, bitField);
        }

        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            return new FinalizeSeekableByteChannel(this.getBoundSocket().newSeekableByteChannel());
        }
    }

    @Immutable
    private static enum SocketFactory {
        NIO2{

            @Override
            InputSocket<?> newInputSocket(FsFinalizeController<?> fsFinalizeController, FsEntryName fsEntryName, BitField<FsInputOption> bitField) {
                FsFinalizeController<?> fsFinalizeController2 = fsFinalizeController;
                fsFinalizeController2.getClass();
                return fsFinalizeController2.new Nio2Input(fsEntryName, bitField);
            }

            @Override
            OutputSocket<?> newOutputSocket(FsFinalizeController<?> fsFinalizeController, FsEntryName fsEntryName, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) {
                FsFinalizeController<?> fsFinalizeController2 = fsFinalizeController;
                fsFinalizeController2.getClass();
                return fsFinalizeController2.new Nio2Output(fsEntryName, bitField, entry);
            }
        }
        ,
        OIO{

            @Override
            InputSocket<?> newInputSocket(FsFinalizeController<?> fsFinalizeController, FsEntryName fsEntryName, BitField<FsInputOption> bitField) {
                FsFinalizeController<?> fsFinalizeController2 = fsFinalizeController;
                fsFinalizeController2.getClass();
                return fsFinalizeController2.new Input(fsEntryName, bitField);
            }

            @Override
            OutputSocket<?> newOutputSocket(FsFinalizeController<?> fsFinalizeController, FsEntryName fsEntryName, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) {
                FsFinalizeController<?> fsFinalizeController2 = fsFinalizeController;
                fsFinalizeController2.getClass();
                return fsFinalizeController2.new Output(fsEntryName, bitField, entry);
            }
        };


        abstract InputSocket<?> newInputSocket(FsFinalizeController<?> var1, FsEntryName var2, BitField<FsInputOption> var3);

        abstract OutputSocket<?> newOutputSocket(FsFinalizeController<?> var1, FsEntryName var2, BitField<FsOutputOption> var3, @CheckForNull Entry var4);
    }
}

