/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsLockModel;
import de.schlichtherle.truezip.fs.FsLockModelDecoratingController;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsNeedsSyncException;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsResourceAccountant;
import de.schlichtherle.truezip.fs.FsResourceOpenException;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncExceptionBuilder;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.FsSyncWarningException;
import de.schlichtherle.truezip.io.DecoratingInputStream;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.io.DecoratingSeekableByteChannel;
import de.schlichtherle.truezip.rof.DecoratingReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.DecoratingInputSocket;
import de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.ControlFlowException;
import de.schlichtherle.truezip.util.ExceptionHandler;
import de.schlichtherle.truezip.util.JSE7;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
final class FsResourceController
extends FsLockModelDecoratingController<FsController<? extends FsLockModel>> {
    private static final SocketFactory SOCKET_FACTORY = JSE7.AVAILABLE ? SocketFactory.NIO2 : SocketFactory.OIO;
    private final FsResourceAccountant accountant = new FsResourceAccountant(this.writeLock());

    FsResourceController(FsController<? extends FsLockModel> fsController) {
        super(fsController);
    }

    @Override
    public InputSocket<?> getInputSocket(FsEntryName fsEntryName, BitField<FsInputOption> bitField) {
        return SOCKET_FACTORY.newInputSocket(this, fsEntryName, bitField);
    }

    @Override
    public OutputSocket<?> getOutputSocket(FsEntryName fsEntryName, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) {
        return SOCKET_FACTORY.newOutputSocket(this, fsEntryName, bitField, entry);
    }

    @Override
    public void sync(BitField<FsSyncOption> bitField) throws FsSyncException {
        assert (this.isWriteLockedByCurrentThread());
        assert (!this.isReadLockedByCurrentThread());
        FsResourceAccountant.Resources resources = this.accountant.resources();
        if (0 == resources.total) {
            this.delegate.sync(bitField);
            return;
        }
        FsSyncExceptionBuilder fsSyncExceptionBuilder = new FsSyncExceptionBuilder();
        boolean bl2 = FsResourceController.forceCloseIo(bitField);
        try {
            if (0 != resources.local && !bl2) {
                throw new FsResourceOpenException(resources.total, resources.local);
            }
            this.accountant.awaitClosingOfOtherThreadsResources(FsResourceController.waitCloseIo(bitField) ? 0L : 100L);
            FsResourceAccountant.Resources resources2 = this.accountant.resources();
            if (0 != resources2.total) {
                throw new FsResourceOpenException(resources2.total, resources2.local);
            }
        }
        catch (FsResourceOpenException fsResourceOpenException) {
            if (!bl2) {
                throw (FsSyncException)fsSyncExceptionBuilder.fail(new FsSyncException((FsModel)this.getModel(), fsResourceOpenException));
            }
            fsSyncExceptionBuilder.warn(new FsSyncWarningException((FsModel)this.getModel(), fsResourceOpenException));
        }
        this.closeResources(fsSyncExceptionBuilder);
        if (resources.needsWaiting()) {
            fsSyncExceptionBuilder.check();
            throw FsNeedsSyncException.get();
        }
        try {
            this.delegate.sync(bitField);
        }
        catch (FsSyncException fsSyncException) {
            throw (FsSyncException)fsSyncExceptionBuilder.fail(fsSyncException);
        }
        fsSyncExceptionBuilder.check();
    }

    private static boolean waitCloseIo(BitField<FsSyncOption> bitField) {
        return bitField.get(FsSyncOption.WAIT_CLOSE_INPUT) || bitField.get(FsSyncOption.WAIT_CLOSE_OUTPUT);
    }

    private static boolean forceCloseIo(BitField<FsSyncOption> bitField) {
        return bitField.get(FsSyncOption.FORCE_CLOSE_INPUT) || bitField.get(FsSyncOption.FORCE_CLOSE_OUTPUT);
    }

    private void closeResources(final FsSyncExceptionBuilder fsSyncExceptionBuilder) {
        final class IOExceptionHandler
        implements ExceptionHandler<IOException, RuntimeException> {
            IOExceptionHandler() {
            }

            @Override
            public RuntimeException fail(IOException iOException) {
                throw new AssertionError((Object)iOException);
            }

            @Override
            public void warn(IOException iOException) {
                fsSyncExceptionBuilder.warn(new FsSyncWarningException((FsModel)FsResourceController.this.getModel(), iOException));
            }
        }
        this.accountant.closeAllResources(new IOExceptionHandler());
    }

    private void close(Closeable closeable, Closeable closeable2) throws IOException {
        boolean bl2 = false;
        try {
            closeable.close();
        }
        catch (ControlFlowException controlFlowException) {
            bl2 = true;
            throw controlFlowException;
        }
        finally {
            if (!bl2) {
                this.accountant.stopAccountingFor(closeable2);
            }
        }
    }

    private final class ResourceOutputStream
    extends DecoratingOutputStream {
        @CreatesObligation
        ResourceOutputStream(@WillCloseWhenClosed OutputStream outputStream) {
            super(outputStream);
            FsResourceController.this.accountant.startAccountingFor(this);
        }

        @Override
        public void close() throws IOException {
            FsResourceController.this.close(this.delegate, this);
        }
    }

    private final class ResourceInputStream
    extends DecoratingInputStream {
        @CreatesObligation
        ResourceInputStream(@WillCloseWhenClosed InputStream inputStream) {
            super(inputStream);
            FsResourceController.this.accountant.startAccountingFor(this);
        }

        @Override
        public void close() throws IOException {
            FsResourceController.this.close(this.delegate, this);
        }
    }

    private final class ResourceSeekableByteChannel
    extends DecoratingSeekableByteChannel {
        @CreatesObligation
        ResourceSeekableByteChannel(@WillCloseWhenClosed SeekableByteChannel seekableByteChannel) {
            super(seekableByteChannel);
            FsResourceController.this.accountant.startAccountingFor(this);
        }

        @Override
        public void close() throws IOException {
            FsResourceController.this.close(this.delegate, this);
        }
    }

    private final class ResourceReadOnlyFile
    extends DecoratingReadOnlyFile {
        @CreatesObligation
        ResourceReadOnlyFile(@WillCloseWhenClosed ReadOnlyFile readOnlyFile) {
            super(readOnlyFile);
            FsResourceController.this.accountant.startAccountingFor(this);
        }

        @Override
        public void close() throws IOException {
            FsResourceController.this.close(this.delegate, this);
        }
    }

    @Immutable
    private class Output
    extends DecoratingOutputSocket<Entry> {
        Output(FsEntryName fsEntryName, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) {
            super(FsResourceController.this.delegate.getOutputSocket(fsEntryName, bitField, entry));
        }

        @Override
        public OutputStream newOutputStream() throws IOException {
            return new ResourceOutputStream(this.getBoundSocket().newOutputStream());
        }
    }

    @Immutable
    private final class Nio2Output
    extends Output {
        Nio2Output(FsEntryName fsEntryName, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) {
            super(fsEntryName, bitField, entry);
        }

        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            return new ResourceSeekableByteChannel(this.getBoundSocket().newSeekableByteChannel());
        }
    }

    @Immutable
    private class Input
    extends DecoratingInputSocket<Entry> {
        Input(FsEntryName fsEntryName, BitField<FsInputOption> bitField) {
            super(FsResourceController.this.delegate.getInputSocket(fsEntryName, bitField));
        }

        @Override
        public ReadOnlyFile newReadOnlyFile() throws IOException {
            return new ResourceReadOnlyFile(this.getBoundSocket().newReadOnlyFile());
        }

        @Override
        public InputStream newInputStream() throws IOException {
            return new ResourceInputStream(this.getBoundSocket().newInputStream());
        }
    }

    @Immutable
    private final class Nio2Input
    extends Input {
        Nio2Input(FsEntryName fsEntryName, BitField<FsInputOption> bitField) {
            super(fsEntryName, bitField);
        }

        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            return new ResourceSeekableByteChannel(this.getBoundSocket().newSeekableByteChannel());
        }
    }

    @Immutable
    private static enum SocketFactory {
        NIO2{

            @Override
            InputSocket<?> newInputSocket(FsResourceController fsResourceController, FsEntryName fsEntryName, BitField<FsInputOption> bitField) {
                FsResourceController fsResourceController2 = fsResourceController;
                fsResourceController2.getClass();
                return fsResourceController2.new Nio2Input(fsEntryName, bitField);
            }

            @Override
            OutputSocket<?> newOutputSocket(FsResourceController fsResourceController, FsEntryName fsEntryName, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) {
                FsResourceController fsResourceController2 = fsResourceController;
                fsResourceController2.getClass();
                return fsResourceController2.new Nio2Output(fsEntryName, bitField, entry);
            }
        }
        ,
        OIO{

            @Override
            InputSocket<?> newInputSocket(FsResourceController fsResourceController, FsEntryName fsEntryName, BitField<FsInputOption> bitField) {
                FsResourceController fsResourceController2 = fsResourceController;
                fsResourceController2.getClass();
                return fsResourceController2.new Input(fsEntryName, bitField);
            }

            @Override
            OutputSocket<?> newOutputSocket(FsResourceController fsResourceController, FsEntryName fsEntryName, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) {
                FsResourceController fsResourceController2 = fsResourceController;
                fsResourceController2.getClass();
                return fsResourceController2.new Output(fsEntryName, bitField, entry);
            }
        };


        abstract InputSocket<?> newInputSocket(FsResourceController var1, FsEntryName var2, BitField<FsInputOption> var3);

        abstract OutputSocket<?> newOutputSocket(FsResourceController var1, FsEntryName var2, BitField<FsOutputOption> var3, @CheckForNull Entry var4);
    }
}

