/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsLockController;
import de.schlichtherle.truezip.fs.FsLockModel;
import de.schlichtherle.truezip.fs.FsLockModelDecoratingController;
import de.schlichtherle.truezip.fs.FsNeedsLockRetryException;
import de.schlichtherle.truezip.fs.FsNeedsSyncException;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsResourceOpenException;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.FsSyncOptions;
import de.schlichtherle.truezip.fs.FsSyncWarningException;
import de.schlichtherle.truezip.io.DecoratingInputStream;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.io.DecoratingSeekableByteChannel;
import de.schlichtherle.truezip.rof.DecoratingReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.DecoratingInputSocket;
import de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.JSE7;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class FsSyncController
extends FsLockModelDecoratingController<FsController<? extends FsLockModel>> {
    private static final SocketFactory SOCKET_FACTORY = JSE7.AVAILABLE ? SocketFactory.NIO2 : SocketFactory.OIO;
    private static final BitField<FsSyncOption> NOT_WAIT_CLOSE_IO = BitField.of((Enum)FsSyncOption.WAIT_CLOSE_INPUT, (Enum[])new FsSyncOption[]{FsSyncOption.WAIT_CLOSE_OUTPUT}).not();

    FsSyncController(FsController<? extends FsLockModel> fsController) {
        super(fsController);
    }

    void sync(FsNeedsSyncException fsNeedsSyncException) throws FsSyncException {
        this.checkWriteLockedByCurrentThread();
        try {
            this.sync(FsSyncOptions.SYNC);
        }
        catch (FsSyncException fsSyncException) {
            if (JSE7.AVAILABLE) {
                fsSyncException.addSuppressed(fsNeedsSyncException);
            }
            throw fsSyncException;
        }
    }

    @Override
    public boolean isReadOnly() throws IOException {
        while (true) {
            try {
                return this.delegate.isReadOnly();
            }
            catch (FsNeedsSyncException fsNeedsSyncException) {
                this.sync(fsNeedsSyncException);
                continue;
            }
            break;
        }
    }

    @Override
    public FsEntry getEntry(FsEntryName fsEntryName) throws IOException {
        while (true) {
            try {
                return this.delegate.getEntry(fsEntryName);
            }
            catch (FsNeedsSyncException fsNeedsSyncException) {
                this.sync(fsNeedsSyncException);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean isReadable(FsEntryName fsEntryName) throws IOException {
        while (true) {
            try {
                return this.delegate.isReadable(fsEntryName);
            }
            catch (FsNeedsSyncException fsNeedsSyncException) {
                this.sync(fsNeedsSyncException);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean isWritable(FsEntryName fsEntryName) throws IOException {
        while (true) {
            try {
                return this.delegate.isWritable(fsEntryName);
            }
            catch (FsNeedsSyncException fsNeedsSyncException) {
                this.sync(fsNeedsSyncException);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean isExecutable(FsEntryName fsEntryName) throws IOException {
        while (true) {
            try {
                return this.delegate.isExecutable(fsEntryName);
            }
            catch (FsNeedsSyncException fsNeedsSyncException) {
                this.sync(fsNeedsSyncException);
                continue;
            }
            break;
        }
    }

    @Override
    public void setReadOnly(FsEntryName fsEntryName) throws IOException {
        while (true) {
            try {
                this.delegate.setReadOnly(fsEntryName);
                return;
            }
            catch (FsNeedsSyncException fsNeedsSyncException) {
                this.sync(fsNeedsSyncException);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean setTime(FsEntryName fsEntryName, Map<Entry.Access, Long> map, BitField<FsOutputOption> bitField) throws IOException {
        while (true) {
            try {
                return this.delegate.setTime(fsEntryName, map, bitField);
            }
            catch (FsNeedsSyncException fsNeedsSyncException) {
                this.sync(fsNeedsSyncException);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean setTime(FsEntryName fsEntryName, BitField<Entry.Access> bitField, long l2, BitField<FsOutputOption> bitField2) throws IOException {
        while (true) {
            try {
                return this.delegate.setTime(fsEntryName, bitField, l2, bitField2);
            }
            catch (FsNeedsSyncException fsNeedsSyncException) {
                this.sync(fsNeedsSyncException);
                continue;
            }
            break;
        }
    }

    @Override
    public InputSocket<?> getInputSocket(FsEntryName fsEntryName, BitField<FsInputOption> bitField) {
        return SOCKET_FACTORY.newInputSocket(this, fsEntryName, bitField);
    }

    @Override
    @SuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
    public OutputSocket<?> getOutputSocket(FsEntryName fsEntryName, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) {
        return SOCKET_FACTORY.newOutputSocket(this, fsEntryName, bitField, entry);
    }

    @Override
    public void mknod(FsEntryName fsEntryName, Entry.Type type, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) throws IOException {
        while (true) {
            try {
                this.delegate.mknod(fsEntryName, type, bitField, entry);
                return;
            }
            catch (FsNeedsSyncException fsNeedsSyncException) {
                this.sync(fsNeedsSyncException);
                continue;
            }
            break;
        }
    }

    @Override
    public void unlink(FsEntryName fsEntryName, BitField<FsOutputOption> bitField) throws IOException {
        while (true) {
            try {
                this.delegate.unlink(fsEntryName, bitField);
                if (fsEntryName.isRoot()) {
                    this.delegate.sync(FsSyncOptions.RESET);
                }
                return;
            }
            catch (FsNeedsSyncException fsNeedsSyncException) {
                this.sync(fsNeedsSyncException);
                continue;
            }
            break;
        }
    }

    @Override
    public void sync(BitField<FsSyncOption> bitField) throws FsSyncException {
        assert (this.isWriteLockedByCurrentThread());
        assert (!this.isReadLockedByCurrentThread());
        BitField<FsSyncOption> bitField2 = FsSyncController.modify(bitField);
        while (true) {
            try {
                this.delegate.sync(bitField2);
                return;
            }
            catch (FsSyncException fsSyncException) {
                if (fsSyncException.getCause() instanceof FsResourceOpenException && bitField2 != bitField) {
                    assert (!(fsSyncException instanceof FsSyncWarningException));
                    throw FsNeedsLockRetryException.get();
                }
                throw fsSyncException;
            }
            catch (FsNeedsSyncException fsNeedsSyncException) {
                continue;
            }
            break;
        }
    }

    private static boolean forceCloseIo(BitField<FsSyncOption> bitField) {
        return bitField.get(FsSyncOption.FORCE_CLOSE_INPUT) || bitField.get(FsSyncOption.FORCE_CLOSE_OUTPUT);
    }

    static BitField<FsSyncOption> modify(BitField<FsSyncOption> bitField) {
        BitField<FsSyncOption> bitField2;
        boolean bl2 = 1 < FsLockController.getLockCount();
        BitField<FsSyncOption> bitField3 = bitField2 = bl2 ? bitField.and(NOT_WAIT_CLOSE_IO) : bitField;
        assert (bitField2 == bitField == bitField2.equals(bitField)) : "Broken contract in BitField.and()!";
        assert (bitField2 == bitField || bl2);
        return bitField2;
    }

    void close(Closeable closeable) throws IOException {
        while (true) {
            try {
                closeable.close();
                return;
            }
            catch (FsNeedsSyncException fsNeedsSyncException) {
                this.sync(fsNeedsSyncException);
                continue;
            }
            break;
        }
    }

    private final class SyncOutputStream
    extends DecoratingOutputStream {
        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        SyncOutputStream(@WillCloseWhenClosed OutputStream outputStream) {
            super(outputStream);
        }

        @Override
        public void close() throws IOException {
            FsSyncController.this.close(this.delegate);
        }
    }

    private final class SyncInputStream
    extends DecoratingInputStream {
        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        SyncInputStream(@WillCloseWhenClosed InputStream inputStream) {
            super(inputStream);
        }

        @Override
        public void close() throws IOException {
            FsSyncController.this.close(this.delegate);
        }
    }

    private final class SyncSeekableByteChannel
    extends DecoratingSeekableByteChannel {
        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        SyncSeekableByteChannel(@WillCloseWhenClosed SeekableByteChannel seekableByteChannel) {
            super(seekableByteChannel);
        }

        @Override
        public void close() throws IOException {
            FsSyncController.this.close(this.delegate);
        }
    }

    private final class SyncReadOnlyFile
    extends DecoratingReadOnlyFile {
        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        SyncReadOnlyFile(@WillCloseWhenClosed ReadOnlyFile readOnlyFile) {
            super(readOnlyFile);
        }

        @Override
        public void close() throws IOException {
            FsSyncController.this.close(this.delegate);
        }
    }

    @Immutable
    private class Output
    extends DecoratingOutputSocket<Entry> {
        Output(FsEntryName fsEntryName, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) {
            super(FsSyncController.this.delegate.getOutputSocket(fsEntryName, bitField, entry));
        }

        @Override
        public Entry getLocalTarget() throws IOException {
            while (true) {
                try {
                    return (Entry)this.getBoundSocket().getLocalTarget();
                }
                catch (FsNeedsSyncException fsNeedsSyncException) {
                    FsSyncController.this.sync(fsNeedsSyncException);
                    continue;
                }
                break;
            }
        }

        @Override
        public OutputStream newOutputStream() throws IOException {
            while (true) {
                try {
                    return new SyncOutputStream(this.getBoundSocket().newOutputStream());
                }
                catch (FsNeedsSyncException fsNeedsSyncException) {
                    FsSyncController.this.sync(fsNeedsSyncException);
                    continue;
                }
                break;
            }
        }
    }

    @Immutable
    private final class Nio2Output
    extends Output {
        Nio2Output(FsEntryName fsEntryName, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) {
            super(fsEntryName, bitField, entry);
        }

        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            while (true) {
                try {
                    return new SyncSeekableByteChannel(this.getBoundSocket().newSeekableByteChannel());
                }
                catch (FsNeedsSyncException fsNeedsSyncException) {
                    FsSyncController.this.sync(fsNeedsSyncException);
                    continue;
                }
                break;
            }
        }
    }

    @Immutable
    private class Input
    extends DecoratingInputSocket<Entry> {
        Input(FsEntryName fsEntryName, BitField<FsInputOption> bitField) {
            super(FsSyncController.this.delegate.getInputSocket(fsEntryName, bitField));
        }

        @Override
        public Entry getLocalTarget() throws IOException {
            while (true) {
                try {
                    return (Entry)this.getBoundSocket().getLocalTarget();
                }
                catch (FsNeedsSyncException fsNeedsSyncException) {
                    FsSyncController.this.sync(fsNeedsSyncException);
                    continue;
                }
                break;
            }
        }

        @Override
        public ReadOnlyFile newReadOnlyFile() throws IOException {
            while (true) {
                try {
                    return new SyncReadOnlyFile(this.getBoundSocket().newReadOnlyFile());
                }
                catch (FsNeedsSyncException fsNeedsSyncException) {
                    FsSyncController.this.sync(fsNeedsSyncException);
                    continue;
                }
                break;
            }
        }

        @Override
        public InputStream newInputStream() throws IOException {
            while (true) {
                try {
                    return new SyncInputStream(this.getBoundSocket().newInputStream());
                }
                catch (FsNeedsSyncException fsNeedsSyncException) {
                    FsSyncController.this.sync(fsNeedsSyncException);
                    continue;
                }
                break;
            }
        }
    }

    @Immutable
    private final class Nio2Input
    extends Input {
        Nio2Input(FsEntryName fsEntryName, BitField<FsInputOption> bitField) {
            super(fsEntryName, bitField);
        }

        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            while (true) {
                try {
                    return new SyncSeekableByteChannel(this.getBoundSocket().newSeekableByteChannel());
                }
                catch (FsNeedsSyncException fsNeedsSyncException) {
                    FsSyncController.this.sync(fsNeedsSyncException);
                    continue;
                }
                break;
            }
        }
    }

    @Immutable
    private static enum SocketFactory {
        NIO2{

            @Override
            InputSocket<?> newInputSocket(FsSyncController fsSyncController, FsEntryName fsEntryName, BitField<FsInputOption> bitField) {
                FsSyncController fsSyncController2 = fsSyncController;
                fsSyncController2.getClass();
                return fsSyncController2.new Nio2Input(fsEntryName, bitField);
            }

            @Override
            OutputSocket<?> newOutputSocket(FsSyncController fsSyncController, FsEntryName fsEntryName, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) {
                FsSyncController fsSyncController2 = fsSyncController;
                fsSyncController2.getClass();
                return fsSyncController2.new Nio2Output(fsEntryName, bitField, entry);
            }
        }
        ,
        OIO{

            @Override
            InputSocket<?> newInputSocket(FsSyncController fsSyncController, FsEntryName fsEntryName, BitField<FsInputOption> bitField) {
                FsSyncController fsSyncController2 = fsSyncController;
                fsSyncController2.getClass();
                return fsSyncController2.new Input(fsEntryName, bitField);
            }

            @Override
            OutputSocket<?> newOutputSocket(FsSyncController fsSyncController, FsEntryName fsEntryName, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) {
                FsSyncController fsSyncController2 = fsSyncController;
                fsSyncController2.getClass();
                return fsSyncController2.new Output(fsEntryName, bitField, entry);
            }
        };


        abstract InputSocket<?> newInputSocket(FsSyncController var1, FsEntryName var2, BitField<FsInputOption> var3);

        abstract OutputSocket<?> newOutputSocket(FsSyncController var1, FsEntryName var2, BitField<FsOutputOption> var3, @CheckForNull Entry var4);
    }
}

