/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsSyncOptions;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class FsSyncShutdownHook {
    private static final Runtime RUNTIME = Runtime.getRuntime();
    private static final Hook hook = new Hook();

    private FsSyncShutdownHook() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(FsManager fsManager) {
        Hook hook = FsSyncShutdownHook.hook;
        if (hook.manager != fsManager) {
            Hook hook2 = hook;
            synchronized (hook2) {
                if (hook.manager != fsManager) {
                    RUNTIME.addShutdownHook(hook);
                    hook.manager = fsManager;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cancel() {
        Hook hook = FsSyncShutdownHook.hook;
        if (hook.manager != null) {
            Hook hook2 = hook;
            synchronized (hook2) {
                if (hook.manager != null) {
                    RUNTIME.removeShutdownHook(hook);
                    hook.manager = null;
                }
            }
        }
    }

    private static final class Hook
    extends Thread {
        @CheckForNull
        volatile FsManager manager;

        Hook() {
            this.setPriority(10);
        }

        @Override
        public void run() {
            FsManager fsManager = this.manager;
            if (fsManager != null) {
                this.manager = null;
                try {
                    fsManager.sync(FsSyncOptions.UMOUNT);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }
}

