/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.util.QuotedUriSyntaxException;
import de.schlichtherle.truezip.util.UriBuilder;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.concurrent.Immutable;

@Immutable
public enum FsUriModifier {
    NULL{

        @Override
        URI modify(URI uRI, PostFix postFix) throws URISyntaxException {
            if (uRI.normalize() != uRI) {
                throw new QuotedUriSyntaxException(uRI, "URI path not in normal form");
            }
            return uRI;
        }
    }
    ,
    CANONICALIZE{

        @Override
        URI modify(URI uRI, PostFix postFix) throws URISyntaxException {
            return postFix.modify(uRI);
        }
    };


    abstract URI modify(URI var1, PostFix var2) throws URISyntaxException;

    @Immutable
    public static enum PostFix {
        PATH{

            @Override
            @SuppressWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"})
            URI modify(URI uRI) throws URISyntaxException {
                int n2;
                String string;
                if (uRI.isOpaque() || !uRI.isAbsolute() || null != uRI.getRawFragment()) {
                    return uRI;
                }
                String string2 = uRI.getRawAuthority();
                String string3 = uRI.getRawPath();
                if (null == string2 && null != string3 && string3.startsWith(PostFix.TWO_SEPARATORS)) {
                    int n3 = string3.indexOf(47, 2);
                    if (2 <= n3) {
                        string2 = string3.substring(2, n3);
                        string3 = string3.substring(n3);
                    }
                    uRI = new UriBuilder(uRI, true).authority(string2).path(string3).getUri();
                }
                uRI = uRI.normalize();
                string2 = uRI.getScheme();
                string3 = uRI.getRawAuthority();
                String string4 = string = uRI.getRawPath();
                while (string.endsWith("/") && (1 <= (n2 = string.length()) && null == string2 || 2 <= n2 && ':' != string.charAt(n2 - 2) || 3 <= n2 && !string.startsWith("/") || 4 < n2 && string.startsWith("/") || null != string3)) {
                    string = string.substring(0, n2 - 1);
                }
                return string != string4 ? new UriBuilder(uRI, true).path(string).getUri() : uRI;
            }
        }
        ,
        MOUNT_POINT{

            @Override
            URI modify(URI uRI) {
                return uRI.normalize();
            }
        }
        ,
        ENTRY_NAME{

            @Override
            @SuppressWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"})
            URI modify(URI uRI) throws URISyntaxException {
                String string;
                if ((uRI = uRI.normalize()).isAbsolute() || null != uRI.getRawAuthority() || null != uRI.getRawFragment()) {
                    return uRI;
                }
                String string2 = string = uRI.getRawPath();
                while (string.startsWith("/")) {
                    string = string.substring(1);
                }
                while (string.endsWith("/")) {
                    string = string.substring(0, string.length() - 1);
                }
                return string == string2 ? uRI : new UriBuilder(uRI, true).path(string).getUri();
            }
        };

        private static final String TWO_SEPARATORS = "//";

        abstract URI modify(URI var1) throws URISyntaxException;
    }
}

