/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.tar;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.archive.tar.TarDriver;
import de.schlichtherle.truezip.fs.archive.tar.TarInputShop;
import de.schlichtherle.truezip.fs.archive.tar.TarOutputShop;
import de.schlichtherle.truezip.socket.IOPoolProvider;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TarGZipDriver
extends TarDriver {
    public static final int BUFFER_SIZE = 8192;

    public TarGZipDriver(IOPoolProvider iOPoolProvider) {
        super(iOPoolProvider);
    }

    public int getBufferSize() {
        return 8192;
    }

    public int getLevel() {
        return 9;
    }

    @Override
    public OutputSocket<?> getOutputSocket(FsController<?> fsController, FsEntryName fsEntryName, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) {
        return fsController.getOutputSocket(fsEntryName, bitField.set(FsOutputOption.STORE), entry);
    }

    @Override
    protected TarInputShop newTarInputShop(FsModel fsModel, InputStream inputStream) throws IOException {
        return super.newTarInputShop(fsModel, new GZIPInputStream(inputStream, this.getBufferSize()));
    }

    @Override
    protected TarOutputShop newTarOutputShop(FsModel fsModel, OutputStream outputStream, TarInputShop tarInputShop) throws IOException {
        return super.newTarOutputShop(fsModel, new GZIPOutputStream(outputStream, this.getBufferSize(), this.getLevel()), tarInputShop);
    }

    private static final class GZIPOutputStream
    extends java.util.zip.GZIPOutputStream {
        GZIPOutputStream(OutputStream outputStream, int n2, int n3) throws IOException {
            super(outputStream, n2);
            this.def.setLevel(n3);
        }
    }
}

