/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.tar;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsCharsetArchiveDriver;
import de.schlichtherle.truezip.fs.archive.tar.TarDriver;
import de.schlichtherle.truezip.fs.archive.tar.TarDriverEntry;
import de.schlichtherle.truezip.io.SequentialIOException;
import de.schlichtherle.truezip.io.SequentialIOExceptionBuilder;
import de.schlichtherle.truezip.io.Streams;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.IOEntry;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.util.HashMaps;
import de.schlichtherle.truezip.util.JSE7;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarUtils;

@NotThreadSafe
public class TarInputShop
implements InputShop<TarDriverEntry> {
    private static final byte[] NULL_RECORD = new byte[512];
    private static final int CHECKSUM_OFFSET = 148;
    private final Map<String, TarDriverEntry> entries = new LinkedHashMap<String, TarDriverEntry>(HashMaps.initialCapacity(47));
    private final TarDriver driver;

    @CreatesObligation
    public TarInputShop(TarDriver tarDriver, @WillNotClose InputStream inputStream) throws EOFException, IOException {
        this.driver = tarDriver;
        if (null == this.driver) {
            throw new NullPointerException();
        }
        try {
            this.unpack(this.newValidatedTarArchiveInputStream(inputStream));
        }
        catch (IOException iOException) {
            block5: {
                try {
                    this.close0();
                }
                catch (Throwable throwable) {
                    if (!JSE7.AVAILABLE) break block5;
                    iOException.addSuppressed(throwable);
                }
            }
            throw iOException;
        }
    }

    private void unpack(@WillNotClose TarArchiveInputStream tarArchiveInputStream) throws IOException {
        TarArchiveEntry tarArchiveEntry;
        TarDriver tarDriver = this.driver;
        IOPool<?> iOPool = tarDriver.getPool();
        while (null != (tarArchiveEntry = tarArchiveInputStream.getNextTarEntry())) {
            String string = TarInputShop.name(tarArchiveEntry);
            TarDriverEntry tarDriverEntry = this.entries.get(string);
            if (null != tarDriverEntry) {
                tarDriverEntry.release();
            }
            tarDriverEntry = tarDriver.newEntry(string, tarArchiveEntry);
            if (!tarArchiveEntry.isDirectory()) {
                IOPool.Entry entry = (IOPool.Entry)iOPool.allocate();
                tarDriverEntry.setTemp(entry);
                try {
                    OutputStream outputStream = entry.getOutputSocket().newOutputStream();
                    IOException iOException = null;
                    try {
                        Streams.cat(tarArchiveInputStream, outputStream);
                    }
                    catch (IOException iOException2) {
                        iOException = iOException2;
                        throw iOException2;
                    }
                    finally {
                        block18: {
                            try {
                                outputStream.close();
                            }
                            catch (IOException iOException3) {
                                if (null == iOException) {
                                    throw iOException3;
                                }
                                if (!JSE7.AVAILABLE) break block18;
                                iOException.addSuppressed(iOException3);
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    block19: {
                        try {
                            entry.release();
                        }
                        catch (IOException iOException4) {
                            if (!JSE7.AVAILABLE) break block19;
                            iOException.addSuppressed(iOException4);
                        }
                    }
                    throw iOException;
                }
            }
            this.entries.put(string, tarDriverEntry);
        }
    }

    private static String name(TarArchiveEntry tarArchiveEntry) {
        String string = tarArchiveEntry.getName();
        Entry.Type type = tarArchiveEntry.isDirectory() ? Entry.Type.DIRECTORY : Entry.Type.FILE;
        return FsCharsetArchiveDriver.toZipOrTarEntryName(string, type);
    }

    private TarArchiveInputStream newValidatedTarArchiveInputStream(InputStream inputStream) throws EOFException, IOException {
        byte[] byArray = new byte[512];
        InputStream inputStream2 = TarInputShop.readAhead(inputStream, byArray);
        if (!Arrays.equals(byArray, NULL_RECORD)) {
            long l2;
            try {
                l2 = TarUtils.parseOctal(byArray, 148, 8);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException("Invalid initial record in TAR file!", illegalArgumentException);
            }
            for (int i2 = 0; i2 < 8; ++i2) {
                byArray[148 + i2] = 32;
            }
            long l3 = TarUtils.computeCheckSum(byArray);
            if (l2 != l3) {
                throw new IOException("Invalid initial record in TAR file: Expected / actual checksum : " + l2 + " / " + l3 + "!");
            }
        }
        return new TarArchiveInputStream(inputStream2, 10240, 512, this.driver.getEncoding());
    }

    static InputStream readAhead(InputStream inputStream, byte[] byArray) throws EOFException, IOException {
        if (inputStream.markSupported()) {
            inputStream.mark(byArray.length);
            new DataInputStream(inputStream).readFully(byArray);
            inputStream.reset();
            return inputStream;
        }
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, byArray.length);
        new DataInputStream(pushbackInputStream).readFully(byArray);
        pushbackInputStream.unread(byArray);
        return pushbackInputStream;
    }

    @Override
    public final int getSize() {
        return this.entries.size();
    }

    @Override
    public final Iterator<TarDriverEntry> iterator() {
        return Collections.unmodifiableCollection(this.entries.values()).iterator();
    }

    @Override
    @CheckForNull
    public final TarDriverEntry getEntry(String string) {
        return this.entries.get(string);
    }

    @Override
    public InputSocket<TarDriverEntry> getInputSocket(final String string) {
        if (null == string) {
            throw new NullPointerException();
        }
        final class Input
        extends InputSocket<TarDriverEntry> {
            Input() {
            }

            @Override
            public TarDriverEntry getLocalTarget() throws IOException {
                TarDriverEntry tarDriverEntry = TarInputShop.this.getEntry(string);
                if (null == tarDriverEntry) {
                    throw new FileNotFoundException(string + " (entry not found)");
                }
                if (tarDriverEntry.isDirectory()) {
                    throw new FileNotFoundException(string + " (cannot read directory entries)");
                }
                return tarDriverEntry;
            }

            @Override
            public ReadOnlyFile newReadOnlyFile() throws IOException {
                return this.getInputSocket().newReadOnlyFile();
            }

            @Override
            public SeekableByteChannel newSeekableByteChannel() throws IOException {
                return this.getInputSocket().newSeekableByteChannel();
            }

            @Override
            public InputStream newInputStream() throws IOException {
                return this.getInputSocket().newInputStream();
            }

            InputSocket<? extends IOEntry<?>> getInputSocket() throws IOException {
                return this.getLocalTarget().getTemp().getInputSocket();
            }
        }
        return new Input();
    }

    @Override
    public void close() throws IOException {
        this.close0();
    }

    private void close0() throws IOException {
        SequentialIOExceptionBuilder<IOException, SequentialIOException> sequentialIOExceptionBuilder = SequentialIOExceptionBuilder.create(IOException.class);
        Iterator<TarDriverEntry> iterator = this.entries.values().iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next().release();
            }
            catch (IOException iOException) {
                sequentialIOExceptionBuilder.warn(iOException);
            }
            iterator.remove();
        }
        sequentialIOExceptionBuilder.check();
    }
}

