/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.tar;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.archive.tar.FixedBufferedOutputStream;
import de.schlichtherle.truezip.fs.archive.tar.TarDriver;
import de.schlichtherle.truezip.fs.archive.tar.TarInputShop;
import de.schlichtherle.truezip.fs.archive.tar.TarOutputShop;
import de.schlichtherle.truezip.socket.IOPoolProvider;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.XZInputStream;
import org.tukaani.xz.XZOutputStream;

@Immutable
public class TarXZDriver
extends TarDriver {
    public static final int BUFFER_SIZE = 8192;

    public TarXZDriver(IOPoolProvider iOPoolProvider) {
        super(iOPoolProvider);
    }

    public int getBufferSize() {
        return 8192;
    }

    public int getPreset() {
        return 6;
    }

    @Override
    public OutputSocket<?> getOutputSocket(FsController<?> fsController, FsEntryName fsEntryName, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) {
        return fsController.getOutputSocket(fsEntryName, bitField.set(FsOutputOption.STORE), entry);
    }

    @Override
    protected TarInputShop newTarInputShop(FsModel fsModel, InputStream inputStream) throws IOException {
        return super.newTarInputShop(fsModel, new XZInputStream(new BufferedInputStream(inputStream, this.getBufferSize())));
    }

    @Override
    protected TarOutputShop newTarOutputShop(FsModel fsModel, OutputStream outputStream, TarInputShop tarInputShop) throws IOException {
        return super.newTarOutputShop(fsModel, new FixedXZOutputStream(new FixedBufferedOutputStream(outputStream, this.getBufferSize()), new LZMA2Options(this.getPreset())), tarInputShop);
    }

    private static final class FixedXZOutputStream
    extends XZOutputStream {
        final FixedBufferedOutputStream out;

        private FixedXZOutputStream(FixedBufferedOutputStream fixedBufferedOutputStream, LZMA2Options lZMA2Options) throws IOException {
            super((OutputStream)fixedBufferedOutputStream, lZMA2Options);
            this.out = fixedBufferedOutputStream;
        }

        @Override
        public void close() throws IOException {
            this.out.ignoreClose = true;
            super.close();
            this.out.ignoreClose = false;
            this.out.close();
        }
    }
}

