/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.zip;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsCharsetArchiveDriver;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.archive.zip.KeyManagerZipCryptoParameters;
import de.schlichtherle.truezip.fs.archive.zip.KeyProviderSyncStrategy;
import de.schlichtherle.truezip.fs.archive.zip.OptionOutputSocket;
import de.schlichtherle.truezip.fs.archive.zip.ZipDriverEntry;
import de.schlichtherle.truezip.fs.archive.zip.ZipInputShop;
import de.schlichtherle.truezip.fs.archive.zip.ZipKeyController;
import de.schlichtherle.truezip.fs.archive.zip.ZipOutputShop;
import de.schlichtherle.truezip.key.KeyManagerProvider;
import de.schlichtherle.truezip.key.sl.KeyManagerLocator;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.IOPoolProvider;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.MultiplexedOutputShop;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.JSE7;
import de.schlichtherle.truezip.zip.ZipCryptoParameters;
import de.schlichtherle.truezip.zip.ZipEntry;
import de.schlichtherle.truezip.zip.ZipFileParameters;
import de.schlichtherle.truezip.zip.ZipOutputStreamParameters;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ZipDriver
extends FsCharsetArchiveDriver<ZipDriverEntry>
implements ZipFileParameters<ZipDriverEntry>,
ZipOutputStreamParameters {
    private static final Logger logger = Logger.getLogger(ZipDriver.class.getName(), ZipDriver.class.getName());
    private static final Charset ZIP_CHARSET = Charset.forName("IBM437");
    private final IOPool<?> ioPool;

    public ZipDriver(IOPoolProvider iOPoolProvider) {
        this(iOPoolProvider, ZIP_CHARSET);
    }

    protected ZipDriver(IOPoolProvider iOPoolProvider, Charset charset) {
        super(charset);
        this.ioPool = iOPoolProvider.get();
        if (null == this.ioPool) {
            throw new NullPointerException();
        }
    }

    protected KeyProviderSyncStrategy getKeyProviderSyncStrategy() {
        return KeyProviderSyncStrategy.RESET_CANCELLED_KEY;
    }

    protected KeyManagerProvider getKeyManagerProvider() {
        return KeyManagerLocator.SINGLETON;
    }

    @CheckForNull
    final ZipCryptoParameters zipCryptoParameters(ZipInputShop zipInputShop) {
        return this.zipCryptoParameters(zipInputShop.getModel(), zipInputShop.getRawCharset());
    }

    @CheckForNull
    final ZipCryptoParameters zipCryptoParameters(ZipOutputShop zipOutputShop) {
        return this.zipCryptoParameters(zipOutputShop.getModel(), zipOutputShop.getRawCharset());
    }

    @CheckForNull
    protected ZipCryptoParameters zipCryptoParameters(FsModel fsModel, Charset charset) {
        return new KeyManagerZipCryptoParameters(this, fsModel, charset);
    }

    public URI mountPointUri(FsModel fsModel) {
        return fsModel.getMountPoint().toHierarchicalUri();
    }

    public URI resourceUri(FsModel fsModel, String string) {
        return this.mountPointUri(fsModel);
    }

    @Override
    public boolean getRedundantContentSupport() {
        return true;
    }

    @Override
    public boolean getRedundantMetaDataSupport() {
        return true;
    }

    protected boolean check(@WillNotClose ZipInputShop zipInputShop, ZipDriverEntry zipDriverEntry) {
        return zipDriverEntry.isEncrypted();
    }

    final boolean process(@WillNotClose ZipInputShop zipInputShop, ZipDriverEntry zipDriverEntry, ZipDriverEntry zipDriverEntry2) {
        return this.process(zipDriverEntry, zipDriverEntry2);
    }

    final boolean process(@WillNotClose ZipOutputShop zipOutputShop, ZipDriverEntry zipDriverEntry, ZipDriverEntry zipDriverEntry2) {
        return this.process(zipDriverEntry2, zipDriverEntry);
    }

    protected boolean process(ZipDriverEntry zipDriverEntry, ZipDriverEntry zipDriverEntry2) {
        return zipDriverEntry.isEncrypted() || zipDriverEntry2.isEncrypted();
    }

    @Override
    protected final IOPool<?> getPool() {
        return this.ioPool;
    }

    @Override
    public boolean getPreambled() {
        return false;
    }

    @Override
    public boolean getPostambled() {
        return false;
    }

    @Override
    @Deprecated
    public int getOverheadSize() {
        return 47;
    }

    @Override
    public int getMethod() {
        return 8;
    }

    @Override
    public int getLevel() {
        return 9;
    }

    @Override
    public FsController<?> newController(FsModel fsModel, FsController<?> fsController) {
        return this.decorate(this.superNewController(fsModel, fsController));
    }

    @Deprecated
    protected final FsController<?> superNewController(FsModel fsModel, FsController<?> fsController) {
        return super.newController(fsModel, fsController);
    }

    public <M extends FsModel> FsController<M> decorate(FsController<M> fsController) {
        return new ZipKeyController<M>(fsController, this);
    }

    @Override
    public ZipDriverEntry newEntry(String string, Entry.Type type, @CheckForNull Entry entry, BitField<FsOutputOption> bitField) throws CharConversionException {
        ZipDriverEntry zipDriverEntry;
        string = ZipDriver.toZipOrTarEntryName(string, type);
        if (entry instanceof ZipEntry) {
            zipDriverEntry = this.newEntry(string, (ZipEntry)((Object)entry));
        } else {
            zipDriverEntry = this.newEntry(string);
            if (null != entry) {
                zipDriverEntry.setTime(entry.getTime(Entry.Access.WRITE));
                zipDriverEntry.setSize(entry.getSize(Entry.Size.DATA));
            }
        }
        if (Entry.Type.DIRECTORY != type) {
            if (-1 == zipDriverEntry.getMethod()) {
                int n2 = bitField.get(FsOutputOption.COMPRESS) ? 8 : (bitField.get(FsOutputOption.STORE) ? 0 : this.getMethod());
                zipDriverEntry.setMethod(n2);
                if (0 != n2) {
                    zipDriverEntry.setCompressedSize(-1L);
                }
            }
            if (bitField.get(FsOutputOption.ENCRYPT)) {
                zipDriverEntry.setEncrypted(true);
            }
        }
        return zipDriverEntry;
    }

    @Override
    public ZipDriverEntry newEntry(String string) {
        return new ZipDriverEntry(string);
    }

    public ZipDriverEntry newEntry(String string, ZipEntry zipEntry) {
        return new ZipDriverEntry(string, zipEntry);
    }

    @Override
    public InputShop<ZipDriverEntry> newInputShop(FsModel fsModel, InputSocket<?> inputSocket) throws IOException {
        if (null == fsModel) {
            throw new NullPointerException();
        }
        ReadOnlyFile readOnlyFile = inputSocket.newReadOnlyFile();
        try {
            return this.newInputShop(fsModel, readOnlyFile);
        }
        catch (IOException iOException) {
            block5: {
                try {
                    readOnlyFile.close();
                }
                catch (IOException iOException2) {
                    if (!JSE7.AVAILABLE) break block5;
                    iOException.addSuppressed(iOException2);
                }
            }
            throw iOException;
        }
    }

    @CreatesObligation
    protected InputShop<ZipDriverEntry> newInputShop(FsModel fsModel, @WillCloseWhenClosed ReadOnlyFile readOnlyFile) throws IOException {
        assert (null != fsModel);
        ZipInputShop zipInputShop = new ZipInputShop(this, fsModel, readOnlyFile);
        try {
            zipInputShop.recoverLostEntries();
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "junkInTheTrunk.warning", new Object[]{this.mountPointUri(fsModel), zipInputShop.getPostambleLength()});
            logger.log(Level.FINE, "junkInTheTrunk.fine", iOException);
        }
        return zipInputShop;
    }

    public OptionOutputSocket getOutputSocket(FsController<?> fsController, FsEntryName fsEntryName, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) {
        if ((bitField = bitField.set(FsOutputOption.STORE)).get(FsOutputOption.GROW)) {
            bitField = bitField.set(FsOutputOption.APPEND).clear(FsOutputOption.CACHE);
        }
        return new OptionOutputSocket(fsController.getOutputSocket(fsEntryName, bitField, entry), bitField);
    }

    @Override
    public final OutputShop<ZipDriverEntry> newOutputShop(FsModel fsModel, OutputSocket<?> outputSocket, InputShop<ZipDriverEntry> inputShop) throws IOException {
        if (null == fsModel) {
            throw new NullPointerException();
        }
        return this.newOutputShop0(fsModel, (OptionOutputSocket)outputSocket, (ZipInputShop)inputShop);
    }

    @CreatesObligation
    private OutputShop<ZipDriverEntry> newOutputShop0(FsModel fsModel, OptionOutputSocket optionOutputSocket, @CheckForNull @WillNotClose ZipInputShop zipInputShop) throws IOException {
        BitField<FsOutputOption> bitField = optionOutputSocket.getOptions();
        if (null != zipInputShop) {
            zipInputShop.setAppendee(bitField.get(FsOutputOption.GROW));
        }
        return this.newOutputShop(fsModel, optionOutputSocket, zipInputShop);
    }

    @CreatesObligation
    protected OutputShop<ZipDriverEntry> newOutputShop(FsModel fsModel, OptionOutputSocket optionOutputSocket, @CheckForNull @WillNotClose ZipInputShop zipInputShop) throws IOException {
        assert (null != fsModel);
        OutputStream outputStream = optionOutputSocket.newOutputStream();
        try {
            return this.newOutputShop(fsModel, outputStream, zipInputShop);
        }
        catch (IOException iOException) {
            block5: {
                try {
                    outputStream.close();
                }
                catch (IOException iOException2) {
                    if (!JSE7.AVAILABLE) break block5;
                    iOException.addSuppressed(iOException2);
                }
            }
            throw iOException;
        }
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    protected OutputShop<ZipDriverEntry> newOutputShop(FsModel fsModel, @WillCloseWhenClosed OutputStream outputStream, @CheckForNull @WillNotClose ZipInputShop zipInputShop) throws IOException {
        return new MultiplexedOutputShop<ZipDriverEntry>(new ZipOutputShop(this, fsModel, outputStream, zipInputShop), this.getPool());
    }
}

