/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.zip;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.archive.zip.ZipDriver;
import de.schlichtherle.truezip.fs.archive.zip.ZipDriverEntry;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.util.JSE7;
import de.schlichtherle.truezip.zip.RawZipFile;
import de.schlichtherle.truezip.zip.ZipCryptoParameters;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ZipInputShop
extends RawZipFile<ZipDriverEntry>
implements InputShop<ZipDriverEntry> {
    private final ZipDriver driver;
    private final FsModel model;
    private boolean appendee;
    private ZipCryptoParameters param;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public ZipInputShop(ZipDriver zipDriver, FsModel fsModel, @WillCloseWhenClosed ReadOnlyFile readOnlyFile) throws IOException {
        super(readOnlyFile, zipDriver);
        this.driver = zipDriver;
        this.model = fsModel;
        if (null == this.model) {
            NullPointerException nullPointerException;
            block3: {
                nullPointerException = new NullPointerException();
                try {
                    super.close();
                }
                catch (Throwable throwable) {
                    if (!JSE7.AVAILABLE) break block3;
                    nullPointerException.addSuppressed(throwable);
                }
            }
            throw nullPointerException;
        }
    }

    public FsModel getModel() {
        return this.model;
    }

    @Override
    protected ZipCryptoParameters getCryptoParameters() {
        ZipCryptoParameters zipCryptoParameters = this.param;
        if (null == zipCryptoParameters) {
            this.param = zipCryptoParameters = this.driver.zipCryptoParameters(this);
        }
        return zipCryptoParameters;
    }

    protected boolean isAppendee() {
        return this.appendee;
    }

    final void setAppendee(boolean bl2) {
        this.appendee = bl2;
    }

    @Override
    public int getSize() {
        return super.size();
    }

    @Override
    public InputSocket<ZipDriverEntry> getInputSocket(final String string) {
        if (null == string) {
            throw new NullPointerException();
        }
        class Input
        extends InputSocket<ZipDriverEntry> {
            Input() {
            }

            @Override
            public ZipDriverEntry getLocalTarget() throws IOException {
                ZipDriverEntry zipDriverEntry = (ZipDriverEntry)ZipInputShop.this.getEntry(string);
                if (null == zipDriverEntry) {
                    throw new FileNotFoundException(string + " (entry not found)");
                }
                if (zipDriverEntry.isDirectory()) {
                    throw new FileNotFoundException(string + " (cannot read directory entries)");
                }
                return zipDriverEntry;
            }

            @Override
            public ReadOnlyFile newReadOnlyFile() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public InputStream newInputStream() throws IOException {
                ZipDriverEntry zipDriverEntry = this.getLocalTarget();
                Entry entry = this.getPeerTarget();
                ZipDriverEntry zipDriverEntry2 = entry instanceof ZipDriverEntry ? (ZipDriverEntry)entry : null;
                ZipDriver zipDriver = ZipInputShop.this.driver;
                return ZipInputShop.this.getInputStream(zipDriverEntry.getName(), zipDriver.check(ZipInputShop.this, zipDriverEntry), null == zipDriverEntry2 || 0L == zipDriverEntry.getSize() || zipDriver.process(ZipInputShop.this, zipDriverEntry, zipDriverEntry2));
            }
        }
        return new Input();
    }
}

