/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.zip;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.archive.zip.ZipDriver;
import de.schlichtherle.truezip.fs.archive.zip.ZipDriverEntry;
import de.schlichtherle.truezip.fs.archive.zip.ZipInputShop;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.io.DisconnectingOutputStream;
import de.schlichtherle.truezip.io.InputException;
import de.schlichtherle.truezip.io.OutputBusyException;
import de.schlichtherle.truezip.io.SequentialIOException;
import de.schlichtherle.truezip.io.SequentialIOExceptionBuilder;
import de.schlichtherle.truezip.io.Streams;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.JSE7;
import de.schlichtherle.truezip.util.JointIterator;
import de.schlichtherle.truezip.zip.RawZipOutputStream;
import de.schlichtherle.truezip.zip.ZipCryptoParameters;
import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ZipOutputShop
extends RawZipOutputStream<ZipDriverEntry>
implements OutputShop<ZipDriverEntry> {
    private final ZipDriver driver;
    private final FsModel model;
    @CheckForNull
    private IOPool.Entry<?> postamble;
    @CheckForNull
    private ZipDriverEntry bufferedEntry;
    private ZipCryptoParameters param;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public ZipOutputShop(ZipDriver zipDriver, FsModel fsModel, @WillCloseWhenClosed OutputStream outputStream, @CheckForNull @WillNotClose ZipInputShop zipInputShop) throws IOException {
        super(outputStream, null != zipInputShop && zipInputShop.isAppendee() ? zipInputShop : null, zipDriver);
        if (null == fsModel) {
            throw new NullPointerException();
        }
        this.driver = zipDriver;
        this.model = fsModel;
        if (null != zipInputShop) {
            if (!zipInputShop.isAppendee()) {
                super.setComment(zipInputShop.getComment());
                if (0L < zipInputShop.getPreambleLength()) {
                    InputStream inputStream = zipInputShop.getPreambleInputStream();
                    try {
                        Streams.cat(inputStream, zipInputShop.offsetsConsiderPreamble() ? this : outputStream);
                    }
                    finally {
                        inputStream.close();
                    }
                }
            }
            if (0L < zipInputShop.getPostambleLength()) {
                this.postamble = (IOPool.Entry)this.getIOPool().allocate();
                Streams.copy(zipInputShop.getPostambleInputStream(), this.postamble.getOutputSocket().newOutputStream());
            }
        }
    }

    public FsModel getModel() {
        return this.model;
    }

    private IOPool<?> getIOPool() {
        return this.driver.getPool();
    }

    @Override
    protected ZipCryptoParameters getCryptoParameters() {
        ZipCryptoParameters zipCryptoParameters = this.param;
        if (null == zipCryptoParameters) {
            this.param = zipCryptoParameters = this.driver.zipCryptoParameters(this);
        }
        return zipCryptoParameters;
    }

    @Override
    public int getSize() {
        return super.size() + (null != this.bufferedEntry ? 1 : 0);
    }

    @Override
    public Iterator<ZipDriverEntry> iterator() {
        ZipDriverEntry zipDriverEntry = this.bufferedEntry;
        if (null == zipDriverEntry) {
            return super.iterator();
        }
        return new JointIterator<ZipDriverEntry>(super.iterator(), Collections.singletonList(zipDriverEntry).iterator());
    }

    @Override
    @CheckForNull
    public ZipDriverEntry getEntry(String string) {
        ZipDriverEntry zipDriverEntry = (ZipDriverEntry)super.getEntry(string);
        if (null != zipDriverEntry) {
            return zipDriverEntry;
        }
        zipDriverEntry = this.bufferedEntry;
        return null != zipDriverEntry && string.equals(zipDriverEntry.getName()) ? zipDriverEntry : null;
    }

    @Override
    public OutputSocket<ZipDriverEntry> getOutputSocket(final ZipDriverEntry zipDriverEntry) {
        if (null == zipDriverEntry) {
            throw new NullPointerException();
        }
        final class Output
        extends OutputSocket<ZipDriverEntry> {
            Output() {
            }

            @Override
            public ZipDriverEntry getLocalTarget() {
                return zipDriverEntry;
            }

            @Override
            public OutputStream newOutputStream() throws IOException {
                if (ZipOutputShop.this.isBusy()) {
                    throw new OutputBusyException(zipDriverEntry.getName());
                }
                if (zipDriverEntry.isDirectory()) {
                    ZipOutputShop.this.updateProperties(zipDriverEntry, DirectoryTemplate.INSTANCE);
                    return new EntryOutputStream(zipDriverEntry, false);
                }
                boolean bl2 = ZipOutputShop.this.updateProperties(zipDriverEntry, this.getPeerTarget());
                if (0 == zipDriverEntry.getMethod() && (-1L == zipDriverEntry.getCrc() || -1L == zipDriverEntry.getSize() || -1L == zipDriverEntry.getCompressedSize())) {
                    assert (bl2) : "The CRC-32, size and compressed size properties must be set when using RDC!";
                    return new BufferedEntryOutputStream(zipDriverEntry);
                }
                return new EntryOutputStream(zipDriverEntry, bl2);
            }
        }
        return new Output();
    }

    boolean updateProperties(ZipDriverEntry zipDriverEntry, @CheckForNull Entry entry) {
        boolean bl2 = true;
        if (-1L == zipDriverEntry.getTime()) {
            zipDriverEntry.setTime(System.currentTimeMillis());
        }
        if (entry != null) {
            ZipDriverEntry zipDriverEntry2;
            if (-1L == zipDriverEntry.getSize()) {
                zipDriverEntry.setSize(entry.getSize(Entry.Size.DATA));
            }
            if (entry instanceof ZipDriverEntry && !(bl2 = this.driver.process(this, zipDriverEntry, zipDriverEntry2 = (ZipDriverEntry)entry))) {
                zipDriverEntry.setPlatform(zipDriverEntry2.getPlatform());
                zipDriverEntry.setEncrypted(zipDriverEntry2.isEncrypted());
                zipDriverEntry.setMethod(zipDriverEntry2.getMethod());
                zipDriverEntry.setCrc(zipDriverEntry2.getCrc());
                zipDriverEntry.setSize(zipDriverEntry2.getSize());
                zipDriverEntry.setCompressedSize(zipDriverEntry2.getCompressedSize());
                zipDriverEntry.setExtra(zipDriverEntry2.getExtra());
            }
        }
        if (0L == zipDriverEntry.getSize()) {
            bl2 = true;
            zipDriverEntry.clearEncryption();
            zipDriverEntry.setMethod(0);
            zipDriverEntry.setCrc(0L);
            zipDriverEntry.setCompressedSize(0L);
        }
        return bl2;
    }

    @Override
    public final boolean isBusy() {
        return super.isBusy() || null != this.bufferedEntry;
    }

    @Override
    public void close() throws IOException {
        super.finish();
        IOPool.Entry<?> entry = this.postamble;
        if (null != entry) {
            this.postamble = null;
            InputSocket inputSocket = entry.getInputSocket();
            IOException iOException = null;
            try {
                InputStream inputStream = inputSocket.newInputStream();
                try {
                    long l2 = this.length();
                    long l3 = ((Entry)inputSocket.getLocalTarget()).getSize(Entry.Size.DATA);
                    if ((l2 + l3) % 4L != 0L) {
                        this.write(new byte[4 - (int)(l2 % 4L)]);
                    }
                    Streams.cat(inputStream, this);
                }
                catch (IOException iOException2) {
                    iOException = iOException2;
                    throw iOException2;
                }
                finally {
                    block23: {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException3) {
                            if (null == iOException) {
                                throw iOException3;
                            }
                            if (!JSE7.AVAILABLE) break block23;
                            iOException.addSuppressed(iOException3);
                        }
                    }
                }
            }
            catch (IOException iOException4) {
                iOException = iOException4;
                throw iOException4;
            }
            finally {
                block24: {
                    try {
                        entry.release();
                    }
                    catch (IOException iOException5) {
                        if (null == iOException) {
                            throw iOException5;
                        }
                        if (!JSE7.AVAILABLE) break block24;
                        iOException.addSuppressed(iOException5);
                    }
                }
            }
        }
        super.close();
    }

    @CleanupObligation
    private final class BufferedEntryOutputStream
    extends DecoratingOutputStream {
        final IOPool.Entry<?> buffer;
        final ZipDriverEntry local;
        boolean closed;

        @CreatesObligation
        BufferedEntryOutputStream(ZipDriverEntry zipDriverEntry) throws IOException {
            super(null);
            assert (0 == zipDriverEntry.getMethod());
            this.local = zipDriverEntry;
            IOPool.Entry entry = this.buffer = (IOPool.Entry)ZipOutputShop.this.getIOPool().allocate();
            try {
                this.delegate = new CheckedOutputStream(entry.getOutputSocket().newOutputStream(), new CRC32());
            }
            catch (IOException iOException) {
                block5: {
                    try {
                        entry.release();
                    }
                    catch (IOException iOException2) {
                        if (!JSE7.AVAILABLE) break block5;
                        iOException.addSuppressed(iOException2);
                    }
                }
                throw iOException;
            }
            ZipOutputShop.this.bufferedEntry = zipDriverEntry;
        }

        @Override
        @DischargesObligation
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            ZipOutputShop.this.bufferedEntry = null;
            this.delegate.close();
            this.updateProperties();
            this.storeBuffer();
        }

        void updateProperties() {
            ZipDriverEntry zipDriverEntry = this.local;
            IOPool.Entry<?> entry = this.buffer;
            zipDriverEntry.setCrc(((CheckedOutputStream)this.delegate).getChecksum().getValue());
            long l2 = entry.getSize(Entry.Size.DATA);
            zipDriverEntry.setSize(l2);
            zipDriverEntry.setCompressedSize(l2);
            ZipOutputShop.this.updateProperties(zipDriverEntry, entry);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void storeBuffer() throws IOException {
            IOPool.Entry<?> entry = this.buffer;
            SequentialIOExceptionBuilder<IOException, SequentialIOException> sequentialIOExceptionBuilder = SequentialIOExceptionBuilder.create(IOException.class, SequentialIOException.class);
            try {
                InputStream inputStream = entry.getInputSocket().newInputStream();
                try {
                    ZipOutputShop zipOutputShop = ZipOutputShop.this;
                    zipOutputShop.putNextEntry(this.local);
                    try {
                        Streams.cat(inputStream, zipOutputShop);
                    }
                    catch (InputException inputException) {
                        sequentialIOExceptionBuilder.warn(inputException);
                    }
                    try {
                        zipOutputShop.closeEntry();
                    }
                    catch (IOException iOException) {
                        sequentialIOExceptionBuilder.warn(iOException);
                    }
                }
                catch (IOException iOException) {
                    sequentialIOExceptionBuilder.warn(iOException);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        sequentialIOExceptionBuilder.warn(iOException);
                    }
                }
            }
            finally {
                try {
                    entry.release();
                }
                catch (IOException iOException) {
                    sequentialIOExceptionBuilder.warn(iOException);
                }
            }
            sequentialIOExceptionBuilder.check();
        }
    }

    @CleanupObligation
    private final class EntryOutputStream
    extends DisconnectingOutputStream {
        boolean closed;

        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        EntryOutputStream(ZipDriverEntry zipDriverEntry, boolean bl2) throws IOException {
            super(ZipOutputShop.this);
            ZipOutputShop.this.putNextEntry(zipDriverEntry, bl2);
        }

        @Override
        public boolean isOpen() {
            return !this.closed;
        }

        @Override
        @DischargesObligation
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            ZipOutputShop.this.closeEntry();
        }
    }

    private static final class DirectoryTemplate
    implements Entry {
        static final DirectoryTemplate INSTANCE = new DirectoryTemplate();

        private DirectoryTemplate() {
        }

        @Override
        public String getName() {
            return "/";
        }

        @Override
        public long getSize(Entry.Size size) {
            return 0L;
        }

        @Override
        public long getTime(Entry.Access access) {
            return -1L;
        }
    }
}

