/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.nio.file;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsAbstractController;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.nio.file.FileEntry;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.ControlFlowException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
final class FileController
extends FsAbstractController<FsModel> {
    private static final String TWO_SEPARATORS = "//";
    private final Path target;

    FileController(FsModel fsModel) {
        super(fsModel);
        if (null != fsModel.getParent()) {
            throw new IllegalArgumentException();
        }
        URI uRI = fsModel.getMountPoint().toUri();
        if ('\\' == File.separatorChar && null != uRI.getRawAuthority()) {
            try {
                uRI = new URI(uRI.getScheme(), "", TWO_SEPARATORS + uRI.getAuthority() + uRI.getPath(), uRI.getQuery(), uRI.getFragment());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new AssertionError((Object)uRISyntaxException);
            }
        }
        this.target = Paths.get(uRI);
    }

    private BasicFileAttributeView getBasicFileAttributeView(Path path) {
        BasicFileAttributeView basicFileAttributeView = Files.getFileAttributeView(path, BasicFileAttributeView.class, new LinkOption[0]);
        assert (null != basicFileAttributeView);
        return basicFileAttributeView;
    }

    @Override
    public FsController<?> getParent() {
        return null;
    }

    @Override
    public boolean isReadOnly() throws IOException {
        return false;
    }

    @Override
    public FileEntry getEntry(FsEntryName fsEntryName) throws IOException {
        FileEntry fileEntry = new FileEntry(this.target, fsEntryName);
        return Files.exists(fileEntry.getPath(), new LinkOption[0]) ? fileEntry : null;
    }

    @Override
    public boolean isReadable(FsEntryName fsEntryName) throws IOException {
        Path path = this.target.resolve(fsEntryName.getPath());
        return Files.isReadable(path);
    }

    @Override
    public boolean isWritable(FsEntryName fsEntryName) throws IOException {
        Path path = this.target.resolve(fsEntryName.getPath());
        return Files.isWritable(path);
    }

    @Override
    public boolean isExecutable(FsEntryName fsEntryName) throws IOException {
        Path path = this.target.resolve(fsEntryName.getPath());
        return Files.isExecutable(path);
    }

    @Override
    public void setReadOnly(FsEntryName fsEntryName) throws IOException {
        Path path = this.target.resolve(fsEntryName.getPath());
        if (!path.toFile().setReadOnly()) {
            if (Files.exists(path, new LinkOption[0])) {
                throw new AccessDeniedException(path.toString());
            }
            throw new FileNotFoundException(path.toString());
        }
    }

    @Override
    public boolean setTime(FsEntryName fsEntryName, Map<Entry.Access, Long> map, BitField<FsOutputOption> bitField) throws IOException {
        Path path = this.target.resolve(fsEntryName.getPath());
        EnumMap<Entry.Access, Long> enumMap = new EnumMap<Entry.Access, Long>(map);
        this.getBasicFileAttributeView(path).setTimes(FileController.toFileTime((Long)enumMap.remove((Object)Entry.Access.WRITE)), FileController.toFileTime((Long)enumMap.remove((Object)Entry.Access.READ)), FileController.toFileTime((Long)enumMap.remove((Object)Entry.Access.CREATE)));
        return enumMap.isEmpty();
    }

    @Override
    public boolean setTime(FsEntryName fsEntryName, BitField<Entry.Access> bitField, long l2, BitField<FsOutputOption> bitField2) throws IOException {
        Path path = this.target.resolve(fsEntryName.getPath());
        FileTime fileTime = FileTime.fromMillis(l2);
        this.getBasicFileAttributeView(path).setTimes(bitField.get(Entry.Access.WRITE) ? fileTime : null, bitField.get(Entry.Access.READ) ? fileTime : null, bitField.get(Entry.Access.CREATE) ? fileTime : null);
        return bitField.clear(Entry.Access.WRITE).clear(Entry.Access.READ).clear(Entry.Access.CREATE).isEmpty();
    }

    @Override
    public InputSocket<?> getInputSocket(FsEntryName fsEntryName, BitField<FsInputOption> bitField) {
        return new FileEntry(this.target, fsEntryName).getInputSocket();
    }

    @Override
    public OutputSocket<?> getOutputSocket(FsEntryName fsEntryName, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) {
        return new FileEntry(this.target, fsEntryName).getOutputSocket(bitField, entry);
    }

    @Override
    public void mknod(FsEntryName fsEntryName, Entry.Type type, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) throws IOException {
        Path path = this.target.resolve(fsEntryName.getPath());
        switch (type) {
            case FILE: {
                if (bitField.get(FsOutputOption.EXCLUSIVE)) {
                    Files.createFile(path, new FileAttribute[0]);
                    break;
                }
                Files.newOutputStream(path, new OpenOption[0]).close();
                break;
            }
            case DIRECTORY: {
                Files.createDirectory(path, new FileAttribute[0]);
                break;
            }
            default: {
                throw new IOException(path + " (entry type not supported: " + (Object)((Object)type) + ")");
            }
        }
        if (null != entry) {
            this.getBasicFileAttributeView(path).setTimes(FileController.toFileTime(entry.getTime(Entry.Access.WRITE)), FileController.toFileTime(entry.getTime(Entry.Access.READ)), FileController.toFileTime(entry.getTime(Entry.Access.CREATE)));
        }
    }

    @Nullable
    private static FileTime toFileTime(Long l2) {
        return null == l2 ? null : FileController.toFileTime((long)l2);
    }

    @Nullable
    private static FileTime toFileTime(long l2) {
        return -1L == l2 ? null : FileTime.fromMillis(l2);
    }

    @Override
    public void unlink(FsEntryName fsEntryName, BitField<FsOutputOption> bitField) throws IOException {
        Path path = this.target.resolve(fsEntryName.getPath());
        Files.delete(path);
    }

    @Override
    public void sync(BitField<FsSyncOption> bitField) throws FsSyncException, ControlFlowException {
    }
}

