/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.nio.file;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.nio.file.FileEntry;
import de.schlichtherle.truezip.io.IOExceptionOutputStream;
import de.schlichtherle.truezip.io.IOExceptionSeekableByteChannel;
import de.schlichtherle.truezip.socket.IOSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.HashMaps;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
final class FileOutputSocket
extends OutputSocket<FileEntry> {
    private static final int INITIAL_CAPACITY = HashMaps.initialCapacity(FsOutputOption.values().length);
    private static final StandardOpenOption[] WRITE_STANDARD_OPEN_OPTION = new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE};
    private final FileEntry entry;
    private final BitField<FsOutputOption> options;
    @CheckForNull
    private final Entry template;

    FileOutputSocket(FileEntry fileEntry, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) {
        assert (null != fileEntry);
        assert (null != bitField);
        if (bitField.get(FsOutputOption.EXCLUSIVE) && bitField.get(FsOutputOption.APPEND)) {
            throw new IllegalArgumentException();
        }
        this.entry = fileEntry;
        this.options = bitField;
        this.template = entry;
    }

    @Override
    public FileEntry getLocalTarget() {
        return this.entry;
    }

    private FileEntry begin() throws IOException {
        FileEntry fileEntry;
        block8: {
            Path path;
            Path path2 = this.entry.getPath();
            Boolean bl2 = null;
            if (this.options.get(FsOutputOption.EXCLUSIVE) && (bl2 = Boolean.valueOf(Files.exists(path2, new LinkOption[0]))).booleanValue()) {
                throw new FileAlreadyExistsException(this.entry.toString());
            }
            if (this.options.get(FsOutputOption.CACHE)) {
                if (Boolean.TRUE.equals(bl2) || null == bl2 && (bl2 = Boolean.valueOf(Files.exists(path2, new LinkOption[0]))).booleanValue()) {
                    path2.getFileSystem().provider().checkAccess(path2, AccessMode.WRITE);
                } else {
                    Files.createFile(path2, new FileAttribute[0]);
                }
                fileEntry = this.entry.createTempFile();
            } else {
                fileEntry = this.entry;
            }
            if (this.options.get(FsOutputOption.CREATE_PARENTS) && !Boolean.TRUE.equals(bl2) && null != (path = path2.getParent())) {
                try {
                    Files.createDirectories(path, new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    if (Files.isDirectory(path, new LinkOption[0])) break block8;
                    throw iOException;
                }
            }
        }
        return fileEntry;
    }

    private void append(FileEntry fileEntry) throws IOException {
        if (fileEntry != this.entry && this.options.get(FsOutputOption.APPEND) && Files.exists(this.entry.getPath(), new LinkOption[0])) {
            IOSocket.copy(this.entry.getInputSocket(), fileEntry.getOutputSocket());
        }
    }

    private Set<OpenOption> optionSet() {
        HashSet<OpenOption> hashSet = new HashSet<OpenOption>(INITIAL_CAPACITY);
        Collections.addAll(hashSet, WRITE_STANDARD_OPEN_OPTION);
        if (this.options.get(FsOutputOption.APPEND)) {
            hashSet.add(StandardOpenOption.APPEND);
            hashSet.remove(StandardOpenOption.TRUNCATE_EXISTING);
        }
        if (this.options.get(FsOutputOption.EXCLUSIVE)) {
            hashSet.add(StandardOpenOption.CREATE_NEW);
        }
        return hashSet;
    }

    private OpenOption[] optionArray() {
        Set<OpenOption> set = this.optionSet();
        return set.toArray(new OpenOption[set.size()]);
    }

    private void close(FileEntry fileEntry, boolean bl2) throws IOException {
        Path path = this.entry.getPath();
        if (fileEntry != this.entry) {
            Path path2 = fileEntry.getPath();
            this.copyAttributes(path2);
            if (bl2) {
                try {
                    Files.move(path2, path, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException iOException) {
                    IOSocket.copy(fileEntry.getInputSocket(), this.entry.getOutputSocket());
                    this.copyAttributes(path);
                }
                this.release(fileEntry, null);
            }
        } else {
            this.copyAttributes(path);
        }
    }

    private void copyAttributes(Path path) throws IOException {
        Entry entry = this.template;
        if (null == entry) {
            return;
        }
        Files.getFileAttributeView(path, BasicFileAttributeView.class, new LinkOption[0]).setTimes(FileOutputSocket.toFileTime(entry.getTime(Entry.Access.WRITE)), FileOutputSocket.toFileTime(entry.getTime(Entry.Access.READ)), FileOutputSocket.toFileTime(entry.getTime(Entry.Access.CREATE)));
    }

    @Nullable
    private static FileTime toFileTime(long l2) {
        return -1L == l2 ? null : FileTime.fromMillis(l2);
    }

    private void release(FileEntry fileEntry, @CheckForNull IOException iOException) throws IOException {
        try {
            fileEntry.release();
        }
        catch (IOException iOException2) {
            iOException2.initCause(iOException);
            throw iOException2;
        }
    }

    @Override
    public SeekableByteChannel newSeekableByteChannel() throws IOException {
        final FileEntry fileEntry = this.begin();
        try {
            this.append(fileEntry);
            class SeekableByteChannel
            extends IOExceptionSeekableByteChannel {
                boolean closed;

                SeekableByteChannel() throws IOException {
                    super(Files.newByteChannel(fileEntry2.getPath(), FileOutputSocket.this.optionSet(), new FileAttribute[0]));
                }

                @Override
                public void close() throws IOException {
                    if (this.closed) {
                        return;
                    }
                    super.close();
                    this.closed = true;
                    FileOutputSocket.this.close(fileEntry, null == this.exception);
                }
            }
            return new SeekableByteChannel();
        }
        catch (IOException iOException) {
            this.release(fileEntry, iOException);
            throw iOException;
        }
    }

    @Override
    public OutputStream newOutputStream() throws IOException {
        final FileEntry fileEntry = this.begin();
        try {
            this.append(fileEntry);
            class OutputStream
            extends IOExceptionOutputStream {
                boolean closed;

                @CreatesObligation
                @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
                OutputStream() throws IOException {
                    super(Files.newOutputStream(fileEntry2.getPath(), FileOutputSocket.this.optionArray()));
                }

                @Override
                public void close() throws IOException {
                    if (this.closed) {
                        return;
                    }
                    super.close();
                    this.closed = true;
                    FileOutputSocket.this.close(fileEntry, null == this.exception);
                }
            }
            return new OutputStream();
        }
        catch (IOException iOException) {
            this.release(fileEntry, iOException);
            throw iOException;
        }
    }
}

