/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.nio.file;

import de.schlichtherle.truezip.fs.nio.file.FileEntry;
import de.schlichtherle.truezip.socket.IOPool;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class TempFilePool
implements IOPool<FileEntry> {
    private static final Path TEMP_DIR = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    private static final FileAttribute<?>[] ATTRIBUTES = TempFilePool.isPosix() ? TempFilePool.posixAttributes() : TempFilePool.emptyAttributes();
    static final TempFilePool INSTANCE = new TempFilePool(null, null);
    @Nullable
    private final Path dir;
    private final String prefix;

    private static boolean isPosix() {
        return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
    }

    private static FileAttribute<?>[] posixAttributes() {
        return new FileAttribute[]{TempFilePool.posixPermissions()};
    }

    private static FileAttribute<?>[] emptyAttributes() {
        return new FileAttribute[0];
    }

    private static FileAttribute<Set<PosixFilePermission>> posixPermissions() {
        return PosixFilePermissions.asFileAttribute(EnumSet.of(PosixFilePermission.OWNER_READ, new PosixFilePermission[]{PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_WRITE}));
    }

    TempFilePool(@CheckForNull Path path, @CheckForNull String string) {
        this.dir = null != path ? path : TEMP_DIR;
        this.prefix = null != string ? TempFilePool.prefixPlusDot(string) : "tzp";
    }

    private static String prefixPlusDot(String string) {
        return string.endsWith(".") ? string : string + ".";
    }

    @Override
    public Buffer allocate() throws IOException {
        return new Buffer(this.createTempFile(), this);
    }

    private Path createTempFile() throws IOException {
        try {
            return Files.createTempFile(this.dir, this.prefix, null, TempFilePool.attributes());
        }
        catch (IOException iOException) {
            if (Files.exists(this.dir, new LinkOption[0])) {
                throw iOException;
            }
            this.createTempDir();
            return this.createTempFile();
        }
    }

    private static FileAttribute<?>[] attributes() {
        return 0 == ATTRIBUTES.length ? ATTRIBUTES : (FileAttribute[])ATTRIBUTES.clone();
    }

    private void createTempDir() {
        assert (!Files.exists(this.dir, new LinkOption[0]));
        try {
            Files.createDirectories(this.dir, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(this.dir + " (cannot create directory for temporary files)", iOException);
        }
        assert (Files.exists(this.dir, new LinkOption[0]));
    }

    @Override
    public void release(IOPool.Entry<FileEntry> entry) throws IOException {
        entry.release();
    }

    @NotThreadSafe
    private static final class Buffer
    extends FileEntry
    implements IOPool.Entry<FileEntry> {
        Buffer(Path path, TempFilePool tempFilePool) {
            super(path);
            assert (null != path);
            assert (null != tempFilePool);
            this.pool = tempFilePool;
        }

        @Override
        public void release() throws IOException {
            this.pool(null);
        }

        private void pool(@CheckForNull TempFilePool tempFilePool) throws IOException {
            TempFilePool tempFilePool2 = this.pool;
            this.pool = tempFilePool;
            if (tempFilePool2 != tempFilePool) {
                Files.deleteIfExists(this.getPath());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.pool(null);
            }
            finally {
                super.finalize();
            }
        }
    }
}

