/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.io;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;

@CleanupObligation
public abstract class DecoratingInputStream
extends InputStream {
    @Nullable
    protected InputStream delegate;

    @CreatesObligation
    protected DecoratingInputStream(@Nullable @WillCloseWhenClosed InputStream inputStream) {
        this.delegate = inputStream;
    }

    @Override
    public int read() throws IOException {
        return this.delegate.read();
    }

    @Override
    public final int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        return this.delegate.read(byArray, n2, n3);
    }

    @Override
    public long skip(long l2) throws IOException {
        return this.delegate.skip(l2);
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    @DischargesObligation
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public void mark(int n2) {
        this.delegate.mark(n2);
    }

    @Override
    public void reset() throws IOException {
        this.delegate.reset();
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    public String toString() {
        return String.format("%s[delegate=%s]", this.getClass().getName(), this.delegate);
    }
}

