/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.io;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;

@CleanupObligation
public abstract class DecoratingOutputStream
extends OutputStream {
    @Nullable
    protected OutputStream delegate;

    @CreatesObligation
    protected DecoratingOutputStream(@Nullable @WillCloseWhenClosed OutputStream outputStream) {
        this.delegate = outputStream;
    }

    @Override
    public void write(int n2) throws IOException {
        this.delegate.write(n2);
    }

    @Override
    public final void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.delegate.write(byArray, n2, n3);
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    @DischargesObligation
    public void close() throws IOException {
        this.delegate.close();
    }

    public String toString() {
        return String.format("%s[delegate=%s]", this.getClass().getName(), this.delegate);
    }
}

