/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.io;

import de.schlichtherle.truezip.io.DecoratingOutputStream;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class LEDataOutputStream
extends DecoratingOutputStream
implements DataOutput {
    private final byte[] buf = new byte[8];
    protected long written;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public LEDataOutputStream(@WillCloseWhenClosed OutputStream outputStream) {
        super(outputStream);
    }

    private void inc(int n2) {
        long l2 = this.written + (long)n2;
        this.written = l2 >= 0L ? l2 : Long.MAX_VALUE;
    }

    @Override
    public void write(int n2) throws IOException {
        this.delegate.write(n2);
        this.inc(1);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.delegate.write(byArray, n2, n3);
        this.inc(n3);
    }

    @Override
    public final void writeBoolean(boolean bl2) throws IOException {
        this.delegate.write(bl2 ? 1 : 0);
        this.inc(1);
    }

    @Override
    public final void writeByte(int n2) throws IOException {
        this.delegate.write(n2);
        this.inc(1);
    }

    @Override
    public final void writeChar(int n2) throws IOException {
        this.writeShort(n2);
    }

    @Override
    public final void writeShort(int n2) throws IOException {
        this.buf[0] = (byte)n2;
        this.buf[1] = (byte)(n2 >>= 8);
        this.delegate.write(this.buf, 0, 2);
        this.inc(2);
    }

    @Override
    public final void writeInt(int n2) throws IOException {
        this.buf[0] = (byte)n2;
        this.buf[1] = (byte)(n2 >>= 8);
        this.buf[2] = (byte)(n2 >>= 8);
        this.buf[3] = (byte)(n2 >>= 8);
        this.delegate.write(this.buf, 0, 4);
        this.inc(4);
    }

    @Override
    public final void writeLong(long l2) throws IOException {
        this.buf[0] = (byte)l2;
        this.buf[1] = (byte)(l2 >>= 8);
        this.buf[2] = (byte)(l2 >>= 8);
        this.buf[3] = (byte)(l2 >>= 8);
        this.buf[4] = (byte)(l2 >>= 8);
        this.buf[5] = (byte)(l2 >>= 8);
        this.buf[6] = (byte)(l2 >>= 8);
        this.buf[7] = (byte)(l2 >>= 8);
        this.delegate.write(this.buf, 0, 8);
        this.inc(8);
    }

    @Override
    public final void writeFloat(float f2) throws IOException {
        this.writeInt(Float.floatToIntBits(f2));
    }

    @Override
    public final void writeDouble(double d2) throws IOException {
        this.writeLong(Double.doubleToLongBits(d2));
    }

    @Override
    public final void writeBytes(String string) throws IOException {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.writeByte(string.charAt(i2));
        }
    }

    @Override
    public final void writeChars(String string) throws IOException {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.writeShort(string.charAt(i2));
        }
    }

    @Override
    public void writeUTF(String string) throws IOException {
        throw new UnsupportedOperationException();
    }

    public final long size() {
        return this.written;
    }
}

